/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.net.PeerServiceResolver;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.net.internal.UrlParser;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.internal.HostAddressAndPortExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal.AddressAndPort;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal.AddressAndPortExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal.ServerAddressAndPortExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class HttpClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final AttributeKey<String> PEER_SERVICE = AttributeKey.stringKey("peer.service");
    private final AddressAndPortExtractor<REQUEST> addressAndPortExtractor;
    private final HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter;
    private final PeerServiceResolver peerServiceResolver;

    HttpClientPeerServiceAttributesExtractor(AddressAndPortExtractor<REQUEST> addressAndPortExtractor, HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, PeerServiceResolver peerServiceResolver) {
        this.addressAndPortExtractor = addressAndPortExtractor;
        this.attributesGetter = attributesGetter;
        this.peerServiceResolver = peerServiceResolver;
    }

    public static <REQUEST, RESPONSE> HttpClientPeerServiceAttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, PeerServiceResolver peerServiceResolver) {
        ServerAddressAndPortExtractor<REQUEST> addressAndPortExtractor = new ServerAddressAndPortExtractor<REQUEST>(attributesGetter, new HostAddressAndPortExtractor<REQUEST>(attributesGetter));
        return new HttpClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>(addressAndPortExtractor, attributesGetter, peerServiceResolver);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (this.peerServiceResolver.isEmpty()) {
            return;
        }
        AddressAndPort addressAndPort = this.addressAndPortExtractor.extract(request);
        Supplier<String> pathSupplier = () -> this.getUrlPath(this.attributesGetter, request);
        String peerService = this.mapToPeerService(addressAndPort.getAddress(), addressAndPort.getPort(), pathSupplier);
        if (peerService != null) {
            attributes.put(PEER_SERVICE, peerService);
        }
    }

    @Nullable
    private String mapToPeerService(@Nullable String host, @Nullable Integer port, Supplier<String> pathSupplier) {
        if (host == null) {
            return null;
        }
        return this.peerServiceResolver.resolveService(host, port, pathSupplier);
    }

    @Nullable
    private String getUrlPath(HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, REQUEST request) {
        String urlFull = attributesGetter.getUrlFull(request);
        if (urlFull == null) {
            return null;
        }
        return UrlParser.getPath(urlFull);
    }
}

