/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.AutoValue_HttpClientMetrics_State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpMetricsAdvice;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class HttpClientMetrics
implements OperationListener {
    private static final double NANOS_PER_S = TimeUnit.SECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_CLIENT_REQUEST_METRICS_STATE = ContextKey.named("http-client-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(HttpClientMetrics.class.getName());
    private final DoubleHistogram duration;

    public static OperationMetrics get() {
        return HttpClientMetrics::new;
    }

    private HttpClientMetrics(Meter meter) {
        DoubleHistogramBuilder stableDurationBuilder = meter.histogramBuilder("http.client.request.duration").setUnit("s").setDescription("Duration of HTTP client requests.").setExplicitBucketBoundariesAdvice(HttpMetricsAdvice.DURATION_SECONDS_BUCKETS);
        HttpMetricsAdvice.applyClientDurationAdvice(stableDurationBuilder);
        this.duration = stableDurationBuilder.build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(HTTP_CLIENT_REQUEST_METRICS_STATE, new AutoValue_HttpClientMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        State state = context.get(HTTP_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        Attributes attributes = state.startAttributes().toBuilder().putAll(endAttributes).build();
        this.duration.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_S, attributes, context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

