/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.internal;

import io.opentelemetry.javaagent.bootstrap.internal.DeprecatedConfigProperties;
import io.opentelemetry.javaagent.bootstrap.internal.EnduserConfig;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.net.PeerServiceResolver;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.HttpConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class CommonConfig {
    private static final CommonConfig instance = new CommonConfig(InstrumentationConfig.get());
    private final PeerServiceResolver peerServiceResolver;
    private final List<String> clientRequestHeaders;
    private final List<String> clientResponseHeaders;
    private final List<String> serverRequestHeaders;
    private final List<String> serverResponseHeaders;
    private final Set<String> knownHttpRequestMethods;
    private final EnduserConfig enduserConfig;
    private final boolean statementSanitizationEnabled;
    private final boolean emitExperimentalHttpClientTelemetry;
    private final boolean emitExperimentalHttpServerTelemetry;

    public static CommonConfig get() {
        return instance;
    }

    CommonConfig(InstrumentationConfig config) {
        this.peerServiceResolver = PeerServiceResolver.create(config.getMap("otel.instrumentation.common.peer-service-mapping", Collections.emptyMap()));
        this.clientRequestHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.client.request", "otel.instrumentation.http.client.capture-request-headers");
        this.clientResponseHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.client.response", "otel.instrumentation.http.client.capture-response-headers");
        this.serverRequestHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.server.request", "otel.instrumentation.http.server.capture-request-headers");
        this.serverResponseHeaders = DeprecatedConfigProperties.getList(config, "otel.instrumentation.http.capture-headers.server.response", "otel.instrumentation.http.server.capture-response-headers");
        this.knownHttpRequestMethods = new HashSet<String>(config.getList("otel.instrumentation.http.known-methods", new ArrayList<String>(HttpConstants.KNOWN_METHODS)));
        this.statementSanitizationEnabled = config.getBoolean("otel.instrumentation.common.db-statement-sanitizer.enabled", true);
        this.emitExperimentalHttpClientTelemetry = DeprecatedConfigProperties.getBoolean(config, "otel.instrumentation.http.client.emit-experimental-metrics", "otel.instrumentation.http.client.emit-experimental-telemetry", false);
        this.emitExperimentalHttpServerTelemetry = DeprecatedConfigProperties.getBoolean(config, "otel.instrumentation.http.server.emit-experimental-metrics", "otel.instrumentation.http.server.emit-experimental-telemetry", false);
        this.enduserConfig = new EnduserConfig(config);
    }

    public PeerServiceResolver getPeerServiceResolver() {
        return this.peerServiceResolver;
    }

    public List<String> getClientRequestHeaders() {
        return this.clientRequestHeaders;
    }

    public List<String> getClientResponseHeaders() {
        return this.clientResponseHeaders;
    }

    public List<String> getServerRequestHeaders() {
        return this.serverRequestHeaders;
    }

    public List<String> getServerResponseHeaders() {
        return this.serverResponseHeaders;
    }

    public Set<String> getKnownHttpRequestMethods() {
        return this.knownHttpRequestMethods;
    }

    public EnduserConfig getEnduserConfig() {
        return this.enduserConfig;
    }

    public boolean isStatementSanitizationEnabled() {
        return this.statementSanitizationEnabled;
    }

    public boolean shouldEmitExperimentalHttpClientTelemetry() {
        return this.emitExperimentalHttpClientTelemetry;
    }

    public boolean shouldEmitExperimentalHttpServerTelemetry() {
        return this.emitExperimentalHttpServerTelemetry;
    }
}

