/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.code;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.code.CodeAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.ClassNames;
import javax.annotation.Nullable;

public final class CodeSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private final CodeAttributesExtractor<REQUEST, ?> attributesExtractor;

    public static <REQUEST> SpanNameExtractor<REQUEST> create(CodeAttributesExtractor<REQUEST, ?> attributesExtractor) {
        return new CodeSpanNameExtractor<REQUEST>(attributesExtractor);
    }

    private CodeSpanNameExtractor(CodeAttributesExtractor<REQUEST, ?> attributesExtractor) {
        this.attributesExtractor = attributesExtractor;
    }

    @Override
    public String extract(REQUEST request) {
        Class<?> cls = this.attributesExtractor.codeClass(request);
        String className = cls != null ? ClassNames.simpleName(cls) : "<unknown>";
        String methodName = CodeSpanNameExtractor.defaultString(this.attributesExtractor.methodName(request));
        return className + "." + methodName;
    }

    private static String defaultString(@Nullable String s) {
        return s == null ? "<unknown>" : s;
    }
}

