/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.caching;

import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.Cache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.CaffeineCache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.shaded.caffeine3.cache.Caffeine;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

final class Caffeine3Cache<K, V>
implements CaffeineCache<K, V> {
    private final io.opentelemetry.javaagent.shaded.instrumentation.api.internal.shaded.caffeine3.cache.Cache<K, V> delegate;

    Caffeine3Cache(io.opentelemetry.javaagent.shaded.instrumentation.api.internal.shaded.caffeine3.cache.Cache<K, V> delegate) {
        this.delegate = delegate;
    }

    public static boolean available() {
        try {
            Caffeine.class.getName();
            return true;
        }
        catch (NoClassDefFoundError | UnsupportedClassVersionError exception) {
            return false;
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.delegate.get((K)key, mappingFunction);
    }

    @Override
    public V get(K key) {
        return this.delegate.getIfPresent(key);
    }

    @Override
    public void put(K key, V value) {
        this.delegate.put(key, value);
    }

    @Override
    public void remove(K key) {
        this.delegate.invalidate(key);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.asMap().keySet();
    }

    @Override
    public void cleanup() {
        this.delegate.cleanUp();
    }

    static class Builder<K, V>
    implements CaffeineCache.Builder<K, V> {
        private final Caffeine<?, ?> caffeine = Caffeine.newBuilder();

        Builder() {
        }

        @Override
        public void weakKeys() {
            this.caffeine.weakKeys();
        }

        @Override
        public void weakValues() {
            this.caffeine.weakValues();
        }

        @Override
        public void maximumSize(@Nonnegative long maximumSize) {
            this.caffeine.maximumSize(maximumSize);
        }

        @Override
        public void executor(@Nonnull Executor executor) {
            this.caffeine.executor(executor);
        }

        @Override
        public Cache<K, V> build() {
            io.opentelemetry.javaagent.shaded.instrumentation.api.internal.shaded.caffeine3.cache.Cache delegate = this.caffeine.build();
            return new Caffeine3Cache(delegate);
        }
    }
}

