/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.net.NetPeerAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.InetSocketAddress;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class DatabaseClientTracer<CONNECTION, STATEMENT, SANITIZEDSTATEMENT>
extends BaseTracer {
    private static final String DB_QUERY = "DB Query";
    protected final NetPeerAttributes netPeerAttributes;

    protected DatabaseClientTracer(NetPeerAttributes netPeerAttributes) {
        this.netPeerAttributes = netPeerAttributes;
    }

    protected DatabaseClientTracer(OpenTelemetry openTelemetry, NetPeerAttributes netPeerAttributes) {
        super(openTelemetry);
        this.netPeerAttributes = netPeerAttributes;
    }

    public boolean shouldStartSpan(Context parentContext) {
        return this.shouldStartSpan(parentContext, SpanKind.CLIENT);
    }

    public Context startSpan(Context parentContext, CONNECTION connection, STATEMENT statement) {
        SANITIZEDSTATEMENT sanitizedStatement = this.sanitizeStatement(statement);
        SpanBuilder span = this.spanBuilder(parentContext, this.spanName(connection, statement, sanitizedStatement), SpanKind.CLIENT).setAttribute(SemanticAttributes.DB_SYSTEM, this.dbSystem(connection));
        if (connection != null) {
            this.onConnection(span, connection);
            this.setNetSemanticConvention(span, connection);
        }
        this.onStatement(span, connection, statement, sanitizedStatement);
        return this.withClientSpan(parentContext, span.startSpan());
    }

    protected abstract SANITIZEDSTATEMENT sanitizeStatement(STATEMENT var1);

    protected String spanName(CONNECTION connection, STATEMENT statement, SANITIZEDSTATEMENT sanitizedStatement) {
        return DatabaseClientTracer.conventionSpanName(this.dbName(connection), this.dbOperation(connection, statement, sanitizedStatement), null);
    }

    public static String conventionSpanName(@Nullable String dbName, @Nullable String operation, @Nullable String table) {
        return DatabaseClientTracer.conventionSpanName(dbName, operation, table, DB_QUERY);
    }

    public static String conventionSpanName(@Nullable String dbName, @Nullable String operation, @Nullable String table, String defaultValue) {
        if (operation == null) {
            return dbName == null ? defaultValue : dbName;
        }
        StringBuilder name = new StringBuilder(operation);
        if (dbName != null || table != null) {
            name.append(' ');
        }
        if (dbName != null) {
            name.append(dbName);
            if (table != null) {
                name.append('.');
            }
        }
        if (table != null) {
            name.append(table);
        }
        return name.toString();
    }

    protected abstract String dbSystem(CONNECTION var1);

    protected void onConnection(SpanBuilder span, CONNECTION connection) {
        span.setAttribute(SemanticAttributes.DB_USER, this.dbUser(connection));
        span.setAttribute(SemanticAttributes.DB_NAME, this.dbName(connection));
        span.setAttribute(SemanticAttributes.DB_CONNECTION_STRING, this.dbConnectionString(connection));
    }

    protected String dbUser(CONNECTION connection) {
        return null;
    }

    protected String dbName(CONNECTION connection) {
        return null;
    }

    protected @Nullable String dbConnectionString(CONNECTION connection) {
        return null;
    }

    protected void setNetSemanticConvention(SpanBuilder span, CONNECTION connection) {
        this.netPeerAttributes.setNetPeer(span, this.peerAddress(connection));
    }

    protected abstract @Nullable InetSocketAddress peerAddress(CONNECTION var1);

    protected void onStatement(SpanBuilder span, CONNECTION connection, STATEMENT statement, SANITIZEDSTATEMENT sanitizedStatement) {
        span.setAttribute(SemanticAttributes.DB_STATEMENT, this.dbStatement(connection, statement, sanitizedStatement));
        span.setAttribute(SemanticAttributes.DB_OPERATION, this.dbOperation(connection, statement, sanitizedStatement));
    }

    protected String dbStatement(CONNECTION connection, STATEMENT statement, SANITIZEDSTATEMENT sanitizedStatement) {
        return null;
    }

    protected String dbOperation(CONNECTION connection, STATEMENT statement, SANITIZEDSTATEMENT sanitizedStatement) {
        return null;
    }
}

