/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.propagation;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.baggage.propagation.Element;
import javax.annotation.Nullable;

class Parser {
    private final String baggageHeader;
    private final Element key = Element.createKeyElement();
    private final Element value = Element.createValueElement();
    private String meta;
    private State state;
    private int metaStart;
    private boolean skipToNext;

    public Parser(String baggageHeader) {
        this.baggageHeader = baggageHeader;
        this.reset(0);
    }

    void parseInto(BaggageBuilder baggageBuilder) {
        int n = this.baggageHeader.length();
        block18: for (int i = 0; i < n; ++i) {
            char current = this.baggageHeader.charAt(i);
            if (this.skipToNext) {
                if (current != ',') continue;
                this.reset(i + 1);
                continue;
            }
            switch (current) {
                case '=': {
                    if (this.state != State.KEY) continue block18;
                    if (this.key.tryTerminating(i, this.baggageHeader)) {
                        this.setState(State.VALUE, i + 1);
                        continue block18;
                    }
                    this.skipToNext = true;
                    continue block18;
                }
                case ';': {
                    if (this.state != State.VALUE) continue block18;
                    this.skipToNext = !this.value.tryTerminating(i, this.baggageHeader);
                    this.setState(State.META, i + 1);
                    continue block18;
                }
                case ',': {
                    switch (this.state) {
                        case VALUE: {
                            this.value.tryTerminating(i, this.baggageHeader);
                            break;
                        }
                        case META: {
                            this.meta = this.baggageHeader.substring(this.metaStart, i).trim();
                            break;
                        }
                    }
                    Parser.putBaggage(baggageBuilder, this.key.getValue(), this.value.getValue(), BaggageEntryMetadata.create(this.meta));
                    this.reset(i + 1);
                    continue block18;
                }
                default: {
                    switch (this.state) {
                        case KEY: {
                            this.skipToNext = !this.key.tryNextChar(current, i);
                            continue block18;
                        }
                        case VALUE: {
                            this.skipToNext = !this.value.tryNextChar(current, i);
                            continue block18;
                        }
                    }
                }
            }
        }
        switch (this.state) {
            case KEY: {
                break;
            }
            case META: {
                String rest = this.baggageHeader.substring(this.metaStart).trim();
                Parser.putBaggage(baggageBuilder, this.key.getValue(), this.value.getValue(), BaggageEntryMetadata.create(rest));
                break;
            }
            case VALUE: {
                if (this.skipToNext) break;
                this.value.tryTerminating(this.baggageHeader.length(), this.baggageHeader);
                Parser.putBaggage(baggageBuilder, this.key.getValue(), this.value.getValue(), BaggageEntryMetadata.empty());
            }
        }
    }

    private static void putBaggage(BaggageBuilder baggage, @Nullable String key, @Nullable String value, BaggageEntryMetadata metadata) {
        if (key != null && value != null) {
            baggage.put(key, value, metadata);
        }
    }

    private void reset(int index) {
        this.skipToNext = false;
        this.state = State.KEY;
        this.key.reset(index);
        this.value.reset(index);
        this.meta = "";
        this.metaStart = 0;
    }

    private void setState(State state, int start) {
        this.state = state;
        this.metaStart = start;
    }

    private static enum State {
        KEY,
        VALUE,
        META;

    }
}

