/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.HttpStatusConverter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.ServerSpan;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.SpanNames;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class HttpServerTracer<REQUEST, RESPONSE, CONNECTION, STORAGE>
extends BaseTracer {
    public static final String CONTEXT_ATTRIBUTE = HttpServerTracer.class.getName() + ".Context";
    protected static final String USER_AGENT = "User-Agent";

    protected HttpServerTracer() {
    }

    protected HttpServerTracer(OpenTelemetry openTelemetry) {
        super(openTelemetry);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, STORAGE storage, Method origin) {
        String spanName = SpanNames.fromMethod(origin);
        return this.startSpan(request, connection, storage, spanName);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, STORAGE storage, String spanName) {
        return this.startSpan(request, connection, storage, spanName, -1L);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, @Nullable STORAGE storage, String spanName, long startTimestamp) {
        Context parentContext = this.extract(request, this.getGetter());
        SpanBuilder spanBuilder = this.spanBuilder(parentContext, spanName, SpanKind.SERVER);
        if (startTimestamp >= 0L) {
            spanBuilder.setStartTimestamp(startTimestamp, TimeUnit.NANOSECONDS);
        }
        this.onConnection(spanBuilder, connection);
        this.onRequest(spanBuilder, request);
        this.onConnectionAndRequest(spanBuilder, connection, request);
        Context context = this.withServerSpan(parentContext, spanBuilder.startSpan());
        context = this.customizeContext(context, request);
        this.attachServerContext(context, storage);
        return context;
    }

    protected Context customizeContext(Context context, REQUEST request) {
        return context;
    }

    public void end(Context context, RESPONSE response) {
        this.end(context, response, -1L);
    }

    public void end(Context context, RESPONSE response, long timestamp) {
        Span span = Span.fromContext(context);
        HttpServerTracer.setStatus(span, this.responseStatus(response));
        this.end(context, (RESPONSE)timestamp);
    }

    @Override
    public void endExceptionally(Context context, Throwable throwable) {
        this.endExceptionally(context, throwable, null);
    }

    public void endExceptionally(Context context, Throwable throwable, RESPONSE response) {
        this.endExceptionally(context, throwable, response, -1L);
    }

    public void endExceptionally(Context context, Throwable throwable, RESPONSE response, long timestamp) {
        this.onException(context, throwable);
        Span span = Span.fromContext(context);
        if (response == null) {
            HttpServerTracer.setStatus(span, 500);
        } else {
            HttpServerTracer.setStatus(span, this.responseStatus(response));
        }
        this.end(context, (RESPONSE)timestamp);
    }

    public Span getServerSpan(STORAGE storage) {
        Context attachedContext = this.getServerContext(storage);
        return attachedContext == null ? null : ServerSpan.fromContextOrNull(attachedContext);
    }

    public abstract @Nullable Context getServerContext(STORAGE var1);

    protected void onConnection(SpanBuilder spanBuilder, CONNECTION connection) {
        spanBuilder.setAttribute(SemanticAttributes.NET_PEER_IP, this.peerHostIP(connection));
        Integer port = this.peerPort(connection);
        if (port != null && port > 0) {
            spanBuilder.setAttribute(SemanticAttributes.NET_PEER_PORT, Long.valueOf(port.intValue()));
        }
    }

    protected void onRequest(SpanBuilder spanBuilder, REQUEST request) {
        spanBuilder.setAttribute(SemanticAttributes.HTTP_METHOD, this.method(request));
        spanBuilder.setAttribute(SemanticAttributes.HTTP_USER_AGENT, this.requestHeader(request, USER_AGENT));
        this.setUrl(spanBuilder, request);
    }

    private void setUrl(SpanBuilder spanBuilder, REQUEST request) {
        spanBuilder.setAttribute(SemanticAttributes.HTTP_URL, this.url(request));
    }

    protected void onConnectionAndRequest(SpanBuilder spanBuilder, CONNECTION connection, REQUEST request) {
        String flavor = this.flavor(connection, request);
        if (flavor != null) {
            if (flavor.startsWith("HTTP/")) {
                flavor = flavor.substring("HTTP/".length());
            }
            spanBuilder.setAttribute(SemanticAttributes.HTTP_FLAVOR, flavor);
        }
        spanBuilder.setAttribute(SemanticAttributes.HTTP_CLIENT_IP, this.clientIP(connection, request));
    }

    private String clientIP(CONNECTION connection, REQUEST request) {
        String forwarded = this.requestHeader(request, "Forwarded");
        if (forwarded != null && (forwarded = HttpServerTracer.extractForwardedFor(forwarded)) != null) {
            return forwarded;
        }
        forwarded = this.requestHeader(request, "X-Forwarded-For");
        if (forwarded != null) {
            int endIndex = forwarded.indexOf(44);
            if (endIndex > 0) {
                forwarded = forwarded.substring(0, endIndex);
            }
            if (!forwarded.isEmpty()) {
                return forwarded;
            }
        }
        return this.peerHostIP(connection);
    }

    static String extractForwardedFor(String forwarded) {
        int start = forwarded.toLowerCase().indexOf("for=");
        if (start < 0) {
            return null;
        }
        if ((start += 4) >= forwarded.length() - 1) {
            return null;
        }
        for (int i = start; i < forwarded.length() - 1; ++i) {
            char c = forwarded.charAt(i);
            if (c != ',' && c != ';') continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }

    private static void setStatus(Span span, int status) {
        span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, Long.valueOf(status));
        StatusCode statusCode = HttpStatusConverter.statusFromHttpStatus(status);
        if (statusCode != StatusCode.UNSET) {
            span.setStatus(statusCode);
        }
    }

    protected abstract @Nullable Integer peerPort(CONNECTION var1);

    protected abstract @Nullable String peerHostIP(CONNECTION var1);

    protected abstract String flavor(CONNECTION var1, REQUEST var2);

    protected abstract TextMapGetter<REQUEST> getGetter();

    protected abstract String url(REQUEST var1);

    protected abstract String method(REQUEST var1);

    protected abstract @Nullable String requestHeader(REQUEST var1, String var2);

    protected abstract int responseStatus(RESPONSE var1);

    protected abstract void attachServerContext(Context var1, STORAGE var2);

    protected boolean isRelativeUrl(String url) {
        return !url.startsWith("http://") && !url.startsWith("https://");
    }
}

