/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api;

import io.opentelemetry.javaagent.instrumentation.api.CallDepth;

public final class CallDepthThreadLocalMap {
    private static final ClassValue<ThreadLocalDepth> TLS = new ClassValue<ThreadLocalDepth>(){

        @Override
        protected ThreadLocalDepth computeValue(Class<?> type) {
            return new ThreadLocalDepth();
        }
    };

    public static CallDepth getCallDepth(Class<?> k) {
        return (CallDepth)TLS.get(k).get();
    }

    public static int incrementCallDepth(Class<?> k) {
        return ((CallDepth)TLS.get(k).get()).getAndIncrement();
    }

    public static int decrementCallDepth(Class<?> k) {
        return ((CallDepth)TLS.get(k).get()).decrementAndGet();
    }

    public static void reset(Class<?> k) {
        ((CallDepth)TLS.get(k).get()).reset();
    }

    private CallDepthThreadLocalMap() {
    }

    private static final class ThreadLocalDepth
    extends ThreadLocal<CallDepth> {
        private ThreadLocalDepth() {
        }

        @Override
        protected CallDepth initialValue() {
            return new CallDepth();
        }
    }
}

