/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.code;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CodeAttributesExtractor<REQUEST, RESPONSE>
extends AttributesExtractor<REQUEST, RESPONSE> {
    @Override
    protected final void onStart(AttributesBuilder attributes, REQUEST request) {
        Class<?> cls = this.codeClass(request);
        if (cls != null) {
            CodeAttributesExtractor.set(attributes, SemanticAttributes.CODE_NAMESPACE, cls.getName());
        }
        CodeAttributesExtractor.set(attributes, SemanticAttributes.CODE_FUNCTION, this.methodName(request));
        CodeAttributesExtractor.set(attributes, SemanticAttributes.CODE_FILEPATH, this.filePath(request));
        CodeAttributesExtractor.set(attributes, SemanticAttributes.CODE_LINENO, this.lineNumber(request));
    }

    @Override
    protected final void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
    }

    protected abstract @Nullable Class<?> codeClass(REQUEST var1);

    protected abstract @Nullable String methodName(REQUEST var1);

    protected abstract @Nullable String filePath(REQUEST var1);

    protected abstract @Nullable Long lineNumber(REQUEST var1);
}

