/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.logs;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.logs.LoggerProvider;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class GlobalLoggerProvider {
    private static final AtomicReference<LoggerProvider> instance = new AtomicReference<LoggerProvider>(LoggerProvider.noop());
    @Nullable
    private static volatile Throwable setInstanceCaller;

    private GlobalLoggerProvider() {
    }

    public static LoggerProvider get() {
        return instance.get();
    }

    public static void set(LoggerProvider loggerProvider) {
        boolean changed = instance.compareAndSet(LoggerProvider.noop(), loggerProvider);
        if (!changed && loggerProvider != LoggerProvider.noop()) {
            throw new IllegalStateException("GlobalLoggerProvider.set has already been called. GlobalLoggerProvider.set must be called only once before any calls to GlobalLoggerProvider.get. Previous invocation set to cause of this exception.", setInstanceCaller);
        }
        setInstanceCaller = new Throwable();
    }

    public static void resetForTest() {
        instance.set(LoggerProvider.noop());
    }
}

