/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import java.util.List;

public final class HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final HttpClientAttributesGetter<REQUEST, RESPONSE> getter;
    CapturedHttpHeaders capturedHttpHeaders = CapturedHttpHeaders.client(Config.get());

    HttpClientAttributesExtractorBuilder(HttpClientAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    @Deprecated
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> captureHttpHeaders(CapturedHttpHeaders capturedHttpHeaders) {
        this.capturedHttpHeaders = capturedHttpHeaders;
        return this;
    }

    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.capturedHttpHeaders = CapturedHttpHeaders.create(requestHeaders, this.capturedHttpHeaders.responseHeaders());
        return this;
    }

    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.capturedHttpHeaders = CapturedHttpHeaders.create(this.capturedHttpHeaders.requestHeaders(), responseHeaders);
        return this;
    }

    public HttpClientAttributesExtractor<REQUEST, RESPONSE> build() {
        return new HttpClientAttributesExtractor<REQUEST, RESPONSE>(this.getter, this.capturedHttpHeaders);
    }
}

