/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class HttpHeaderAttributes {
    private static final ConcurrentMap<String, AttributeKey<List<String>>> requestKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();
    private static final ConcurrentMap<String, AttributeKey<List<String>>> responseKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();

    static AttributeKey<List<String>> requestAttributeKey(String headerName) {
        return requestKeysCache.computeIfAbsent(headerName, n -> HttpHeaderAttributes.createKey("request", n));
    }

    static AttributeKey<List<String>> responseAttributeKey(String headerName) {
        return responseKeysCache.computeIfAbsent(headerName, n -> HttpHeaderAttributes.createKey("response", n));
    }

    private static AttributeKey<List<String>> createKey(String type, String headerName) {
        String key = "http." + type + ".header." + headerName.replace('-', '_');
        return AttributeKey.stringArrayKey(key);
    }

    private HttpHeaderAttributes() {
    }
}

