/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class InternalJarUrlHandler
extends URLStreamHandler {
    private static final WeakReference<ResolvedJarEntry> NULL = new WeakReference<Object>(null);
    private final String name;
    private final FileNotInInternalJar notFound;
    private final JarFile bootstrapJarFile;
    private WeakReference<ResolvedJarEntry> cache = NULL;

    public InternalJarUrlHandler(String internalJarFileName, URL bootstrapJarLocation) {
        this.name = internalJarFileName;
        this.notFound = new FileNotInInternalJar(internalJarFileName);
        JarFile jarFile = null;
        try {
            if (bootstrapJarLocation != null) {
                jarFile = new JarFile(new File(bootstrapJarLocation.toURI()), false);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException("Unable to read internal jar", e);
        }
        this.bootstrapJarFile = jarFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        String filename = url.getFile();
        if ("/".equals(filename)) {
            return new InternalJarUrlConnection(url, new ByteArrayInputStream(new byte[0]), 0L);
        }
        ResolvedJarEntry pair = (ResolvedJarEntry)this.cache.get();
        if (null == pair || !filename.equals(pair.filename)) {
            JarEntry entry = this.bootstrapJarFile.getJarEntry(this.getResourcePath(filename));
            if (null == entry) throw this.notFound;
            pair = new ResolvedJarEntry(filename, entry);
            this.cache = new WeakReference<ResolvedJarEntry>(pair);
            return new InternalJarUrlConnection(url, this.bootstrapJarFile.getInputStream(pair.entry), pair.entry.getSize());
        } else {
            this.cache = NULL;
        }
        return new InternalJarUrlConnection(url, this.bootstrapJarFile.getInputStream(pair.entry), pair.entry.getSize());
    }

    private String getResourcePath(String filename) {
        boolean isClass = filename.endsWith(".class");
        int length = this.name.length() + filename.length();
        if (isClass) {
            length += 4;
        }
        StringBuilder sb = new StringBuilder(length);
        sb.append(this.name).append(filename);
        if (isClass) {
            sb.append("data");
        }
        return sb.toString();
    }

    private static class ResolvedJarEntry {
        private final String filename;
        private final JarEntry entry;

        private ResolvedJarEntry(String filename, JarEntry entry) {
            this.filename = filename;
            this.entry = entry;
        }
    }

    private static class FileNotInInternalJar
    extends IOException {
        public FileNotInInternalJar(String jarName) {
            super("class not found in " + jarName);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class InternalJarUrlConnection
    extends URLConnection {
        private final InputStream inputStream;
        private final long contentLength;

        private InternalJarUrlConnection(URL url, InputStream inputStream, long contentLength) {
            super(url);
            this.inputStream = inputStream;
            this.contentLength = contentLength;
        }

        @Override
        public void connect() {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStream;
        }

        @Override
        public Permission getPermission() {
            return null;
        }

        @Override
        public long getContentLengthLong() {
            return this.contentLength;
        }
    }
}

