/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.InternalJarUrlHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class AgentClassLoader
extends URLClassLoader {
    private static final String AGENT_INITIALIZER_JAR;
    private final BootstrapClassLoaderProxy bootstrapProxy;

    public AgentClassLoader(URL bootstrapJarLocation, String internalJarFileName, ClassLoader parent) {
        super(new URL[0], parent);
        this.bootstrapProxy = bootstrapJarLocation == null ? new BootstrapClassLoaderProxy(new URL[0]) : new BootstrapClassLoaderProxy(new URL[]{bootstrapJarLocation});
        InternalJarUrlHandler internalJarUrlHandler = new InternalJarUrlHandler(internalJarFileName, bootstrapJarLocation);
        try {
            this.addURL(new URL("x-internal-jar", null, 0, "/", internalJarUrlHandler));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("URL malformed.  Unsupported JDK?", e);
        }
        if (!AGENT_INITIALIZER_JAR.isEmpty()) {
            URL url;
            try {
                url = new File(AGENT_INITIALIZER_JAR).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Filename could not be parsed: " + AGENT_INITIALIZER_JAR + ". Initializer is not installed", e);
            }
            this.addURL(url);
        }
    }

    @Override
    public URL getResource(String resourceName) {
        URL bootstrapResource = this.bootstrapProxy.getResource(resourceName);
        if (null == bootstrapResource) {
            return super.getResource(resourceName);
        }
        return bootstrapResource;
    }

    public BootstrapClassLoaderProxy getBootstrapProxy() {
        return this.bootstrapProxy;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        AGENT_INITIALIZER_JAR = System.getProperty("otel.javaagent.experimental.initializer.jar", "");
    }

    public static final class BootstrapClassLoaderProxy
    extends URLClassLoader {
        public BootstrapClassLoaderProxy(URL[] urls) {
            super(urls, (ClassLoader)null);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

