/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

import io.opentelemetry.javaagent.shaded.instrumentation.api.InstrumentationVersion;
import io.opentelemetry.javaagent.shaded.instrumentation.api.context.ContextPropagationDebug;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.GlobalMetricsProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class BaseTracer {
    private static final Meter meterProvider = GlobalMetricsProvider.getMeter("io.opentelemetry.javaagent.shaded.instrumentation.api.tracer");
    private static final Logger log = LoggerFactory.getLogger(BaseTracer.class);
    private static final ContextKey<Span> CONTEXT_SERVER_SPAN_KEY = ContextKey.named("opentelemetry-trace-server-span-key");
    private static final ContextKey<Span> CONTEXT_CLIENT_SPAN_KEY = ContextKey.named("opentelemetry-trace-auto-client-span-key");
    protected final Tracer tracer;
    protected final ContextPropagators propagators;
    private final LongCounter suppressionCounter = meterProvider.longCounterBuilder("agent.suppressed.spans").setDescription("The number of spans that have been suppressed by the instrumentation.").setUnit("1").build();

    public BaseTracer() {
        this.tracer = GlobalOpenTelemetry.getTracer(this.getInstrumentationName(), this.getVersion());
        this.propagators = GlobalOpenTelemetry.getPropagators();
    }

    @Deprecated
    public BaseTracer(Tracer tracer) {
        this.tracer = tracer;
        this.propagators = GlobalOpenTelemetry.getPropagators();
    }

    public BaseTracer(OpenTelemetry openTelemetry) {
        this.tracer = openTelemetry.getTracer(this.getInstrumentationName(), this.getVersion());
        this.propagators = openTelemetry.getPropagators();
    }

    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    public Context startSpan(Class<?> clazz) {
        return this.startSpan(this.spanNameForClass(clazz));
    }

    public Context startSpan(Method method) {
        return this.startSpan(this.spanNameForMethod(method));
    }

    public Context startSpan(String spanName) {
        return this.startSpan(spanName, SpanKind.INTERNAL);
    }

    public Context startSpan(String spanName, SpanKind kind) {
        return this.startSpan(Context.current(), spanName, kind);
    }

    public Context startSpan(Context parentContext, String spanName, SpanKind kind) {
        Span span = this.spanBuilder(spanName, kind).setParent(parentContext).startSpan();
        return parentContext.with(span);
    }

    protected SpanBuilder spanBuilder(String spanName, SpanKind kind) {
        return this.tracer.spanBuilder(spanName).setSpanKind(kind);
    }

    protected final Context withClientSpan(Context parentContext, Span span) {
        return parentContext.with(span).with(CONTEXT_CLIENT_SPAN_KEY, span);
    }

    protected final Context withServerSpan(Context parentContext, Span span) {
        return parentContext.with(span).with(CONTEXT_SERVER_SPAN_KEY, span);
    }

    protected final boolean shouldStartSpan(SpanKind proposedKind, Context context) {
        boolean suppressed = false;
        switch (proposedKind) {
            case CLIENT: {
                suppressed = this.inClientSpan(context);
                break;
            }
            case SERVER: {
                suppressed = this.inServerSpan(context);
                break;
            }
        }
        if (suppressed) {
            this.suppressionCounter.add(1L, Labels.of("span.kind", proposedKind.name(), "instrumentation.name", this.getInstrumentationName(), "instrumentation.version", this.getVersion()));
        }
        return !suppressed;
    }

    private boolean inClientSpan(Context parentContext) {
        return parentContext.get(CONTEXT_CLIENT_SPAN_KEY) != null;
    }

    private boolean inServerSpan(Context context) {
        return BaseTracer.getCurrentServerSpan(context) != null;
    }

    protected abstract String getInstrumentationName();

    protected String getVersion() {
        return InstrumentationVersion.VERSION;
    }

    public String spanNameForMethod(Method method) {
        return this.spanNameForClass(method.getDeclaringClass()) + "." + method.getName();
    }

    protected String spanNameForMethod(Class<?> clazz, Method method) {
        return this.spanNameForMethod(clazz, null == method ? null : method.getName());
    }

    protected String spanNameForMethod(Class<?> cl, String methodName) {
        return this.spanNameForClass(cl) + "." + methodName;
    }

    public String spanNameForClass(Class<?> clazz) {
        String pkgName;
        if (!clazz.isAnonymousClass()) {
            return clazz.getSimpleName();
        }
        String className = clazz.getName();
        if (clazz.getPackage() != null && !(pkgName = clazz.getPackage().getName()).isEmpty()) {
            className = clazz.getName().replace(pkgName, "").substring(1);
        }
        return className;
    }

    public void end(Context context) {
        this.end(context, -1L);
    }

    public void end(Context context, long endTimeNanos) {
        this.end(Span.fromContext(context), endTimeNanos);
    }

    @Deprecated
    public void end(Span span) {
        this.end(span, -1L);
    }

    @Deprecated
    public void end(Span span, long endTimeNanos) {
        if (endTimeNanos > 0L) {
            span.end(endTimeNanos, TimeUnit.NANOSECONDS);
        } else {
            span.end();
        }
    }

    public void endExceptionally(Context context, Throwable throwable) {
        this.endExceptionally(context, throwable, -1L);
    }

    public void endExceptionally(Context context, Throwable throwable, long endTimeNanos) {
        this.endExceptionally(Span.fromContext(context), throwable, endTimeNanos);
    }

    @Deprecated
    public void endExceptionally(Span span, Throwable throwable) {
        this.endExceptionally(span, throwable, -1L);
    }

    @Deprecated
    public void endExceptionally(Span span, Throwable throwable, long endTimeNanos) {
        span.setStatus(StatusCode.ERROR);
        this.onError(span, this.unwrapThrowable(throwable));
        this.end(span, endTimeNanos);
    }

    protected void onError(Span span, Throwable throwable) {
        this.addThrowable(span, throwable);
    }

    protected Throwable unwrapThrowable(Throwable throwable) {
        return throwable instanceof ExecutionException ? throwable.getCause() : throwable;
    }

    public void addThrowable(Span span, Throwable throwable) {
        span.recordException(throwable);
    }

    @Deprecated
    public static <C> Context extractWithGlobalPropagators(C carrier, TextMapGetter<C> getter) {
        return BaseTracer.extract(GlobalOpenTelemetry.getPropagators(), carrier, getter);
    }

    public <C> Context extract(C carrier, TextMapGetter<C> getter) {
        return BaseTracer.extract(this.propagators, carrier, getter);
    }

    private static <C> Context extract(ContextPropagators propagators, C carrier, TextMapGetter<C> getter) {
        ContextPropagationDebug.debugContextLeakIfEnabled();
        return propagators.getTextMapPropagator().extract(Context.root(), carrier, getter);
    }

    public static Span getCurrentServerSpan() {
        return BaseTracer.getCurrentServerSpan(Context.current());
    }

    public static Span getCurrentServerSpan(Context context) {
        return context.get(CONTEXT_SERVER_SPAN_KEY);
    }
}

