/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.tracer;

import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.HttpStatusConverter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.tracer.utils.NetPeerUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class HttpClientTracer<REQUEST, CARRIER, RESPONSE>
extends BaseTracer {
    private static final Logger log = LoggerFactory.getLogger(HttpClientTracer.class);
    public static final String DEFAULT_SPAN_NAME = "HTTP request";
    protected static final String USER_AGENT = "User-Agent";

    protected HttpClientTracer() {
    }

    @Deprecated
    protected HttpClientTracer(Tracer tracer) {
        super(tracer);
    }

    protected HttpClientTracer(OpenTelemetry openTelemetry) {
        super(openTelemetry);
    }

    protected abstract String method(REQUEST var1);

    protected abstract @Nullable URI url(REQUEST var1) throws URISyntaxException;

    protected @Nullable String flavor(REQUEST request) {
        return "1.1";
    }

    protected abstract Integer status(RESPONSE var1);

    protected abstract @Nullable String requestHeader(REQUEST var1, String var2);

    protected abstract @Nullable String responseHeader(RESPONSE var1, String var2);

    protected abstract TextMapPropagator.Setter<CARRIER> getSetter();

    public boolean shouldStartSpan(Context parentContext) {
        return this.shouldStartSpan(SpanKind.CLIENT, parentContext);
    }

    public Context startSpan(Context parentContext, REQUEST request, CARRIER carrier) {
        return this.startSpan(parentContext, request, carrier, -1L);
    }

    public Context startSpan(SpanKind kind, Context parentContext, REQUEST request, CARRIER carrier, long startTimeNanos) {
        Span span = this.internalStartSpan(kind, parentContext, request, this.spanNameForRequest(request), startTimeNanos);
        Context context = this.withClientSpan(parentContext, span);
        this.inject(context, carrier);
        return context;
    }

    public Context startSpan(Context parentContext, REQUEST request, CARRIER carrier, long startTimeNanos) {
        return this.startSpan(SpanKind.CLIENT, parentContext, request, carrier, startTimeNanos);
    }

    protected void inject(Context context, CARRIER carrier) {
        TextMapPropagator.Setter<CARRIER> setter = this.getSetter();
        if (setter == null) {
            throw new IllegalStateException("getSetter() not defined but calling startScope(), either getSetter must be implemented or the scope should be setup manually");
        }
        this.propagators.getTextMapPropagator().inject(context, carrier, setter);
    }

    public void end(Context context, RESPONSE response) {
        this.end(context, response, -1L);
    }

    public void end(Context context, RESPONSE response, long endTimeNanos) {
        Span span = Span.fromContext(context);
        this.onResponse(span, response);
        super.end(span, endTimeNanos);
    }

    public void endExceptionally(Context context, RESPONSE response, Throwable throwable) {
        this.endExceptionally(context, response, throwable, -1L);
    }

    public void endExceptionally(Context context, RESPONSE response, Throwable throwable, long endTimeNanos) {
        Span span = Span.fromContext(context);
        this.onResponse(span, response);
        super.endExceptionally(span, throwable, endTimeNanos);
    }

    public void endMaybeExceptionally(Context context, RESPONSE response, @Nullable Throwable throwable) {
        if (throwable != null) {
            this.endExceptionally(context, throwable);
        } else {
            this.end(context, response);
        }
    }

    private Span internalStartSpan(SpanKind kind, Context parentContext, REQUEST request, String name, long startTimeNanos) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(name).setSpanKind(kind).setParent(parentContext);
        if (startTimeNanos > 0L) {
            spanBuilder.setStartTimestamp(startTimeNanos, TimeUnit.NANOSECONDS);
        }
        Span span = spanBuilder.startSpan();
        this.onRequest(span, request);
        return span;
    }

    protected void onRequest(Span span, REQUEST request) {
        assert (span != null);
        if (request != null) {
            span.setAttribute(SemanticAttributes.NET_TRANSPORT, "IP.TCP");
            span.setAttribute(SemanticAttributes.HTTP_METHOD, this.method(request));
            span.setAttribute(SemanticAttributes.HTTP_USER_AGENT, this.requestHeader(request, USER_AGENT));
            this.setFlavor(span, request);
            this.setUrl(span, request);
        }
    }

    private void setFlavor(Span span, REQUEST request) {
        String flavor = this.flavor(request);
        if (flavor == null) {
            return;
        }
        String httpProtocolPrefix = "HTTP/";
        if (flavor.startsWith(httpProtocolPrefix)) {
            flavor = flavor.substring(httpProtocolPrefix.length());
        }
        span.setAttribute(SemanticAttributes.HTTP_FLAVOR, flavor);
    }

    private void setUrl(Span span, REQUEST request) {
        try {
            URI url = this.url(request);
            if (url != null) {
                NetPeerUtils.INSTANCE.setNetPeer(span, url.getHost(), null, url.getPort());
                span.setAttribute(SemanticAttributes.HTTP_URL, url.toString());
            }
        }
        catch (Exception e) {
            log.debug("Error tagging url", e);
        }
    }

    protected void onResponse(Span span, RESPONSE response) {
        Integer status;
        assert (span != null);
        if (response != null && (status = this.status(response)) != null) {
            span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, Long.valueOf(status.intValue()));
            span.setStatus(HttpStatusConverter.statusFromHttpStatus(status));
        }
    }

    protected String spanNameForRequest(REQUEST request) {
        if (request == null) {
            return DEFAULT_SPAN_NAME;
        }
        String method = this.method(request);
        return method != null ? "HTTP " + method : DEFAULT_SPAN_NAME;
    }
}

