/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.db.normalizer;

import io.opentelemetry.javaagent.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.javaagent.instrumentation.api.db.normalizer.ParseException;
import io.opentelemetry.javaagent.instrumentation.api.db.normalizer.SimpleCharStream;
import io.opentelemetry.javaagent.instrumentation.api.db.normalizer.SqlStatementInfoExtractorConstants;
import io.opentelemetry.javaagent.instrumentation.api.db.normalizer.SqlStatementInfoExtractorTokenManager;
import io.opentelemetry.javaagent.instrumentation.api.db.normalizer.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class SqlStatementInfoExtractor
implements SqlStatementInfoExtractorConstants {
    private Operation operation = NoOp.INSTANCE;
    private int parenLevel = 0;
    private boolean insideComment = false;
    public SqlStatementInfoExtractorTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[2];
    private static int[] jj_la1_0;
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static SqlStatementInfo extract(String statement) throws ParseException {
        if (statement == null) {
            return new SqlStatementInfo(null, null, null);
        }
        statement = statement.trim();
        SqlStatementInfoExtractor parser = new SqlStatementInfoExtractor(new StringReader(statement));
        parser.Input();
        return parser.operation.getResult(statement);
    }

    private void setOperation(Operation operation) {
        if (this.operation == NoOp.INSTANCE) {
            this.operation = operation;
        }
    }

    public final void Input() throws ParseException {
        block22: {
            block21: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block22;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        if (this.insideComment) continue block21;
                        this.setOperation(new Select());
                        continue block21;
                    }
                    case 2: {
                        this.jj_consume_token(2);
                        if (this.insideComment) continue block21;
                        this.setOperation(new Insert());
                        continue block21;
                    }
                    case 3: {
                        this.jj_consume_token(3);
                        if (this.insideComment) continue block21;
                        this.setOperation(new Delete());
                        continue block21;
                    }
                    case 4: {
                        this.jj_consume_token(4);
                        if (this.insideComment) continue block21;
                        this.setOperation(new Update());
                        continue block21;
                    }
                    case 5: {
                        this.jj_consume_token(5);
                        if (this.insideComment) continue block21;
                        this.setOperation(new Merge());
                        continue block21;
                    }
                    case 6: {
                        boolean done;
                        this.jj_consume_token(6);
                        if (this.insideComment || !(done = this.operation.handleFrom())) continue block21;
                        return;
                    }
                    case 7: {
                        boolean done;
                        this.jj_consume_token(7);
                        if (this.insideComment || !(done = this.operation.handleInto())) continue block21;
                        return;
                    }
                    case 8: {
                        boolean done;
                        this.jj_consume_token(8);
                        if (this.insideComment || !(done = this.operation.handleJoin())) continue block21;
                        return;
                    }
                    case 14: {
                        boolean done;
                        Token t = this.jj_consume_token(14);
                        if (this.insideComment || !(done = this.operation.handleIdentifier(t.image))) continue block21;
                        return;
                    }
                    case 9: {
                        boolean done;
                        this.jj_consume_token(9);
                        if (this.insideComment || !(done = this.operation.handleComma())) continue block21;
                        return;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        if (this.insideComment) continue block21;
                        ++this.parenLevel;
                        continue block21;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        if (this.insideComment) continue block21;
                        --this.parenLevel;
                        continue block21;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        this.insideComment = true;
                        continue block21;
                    }
                    case 13: {
                        this.jj_consume_token(13);
                        this.insideComment = false;
                        continue block21;
                    }
                    case 16: {
                        this.jj_consume_token(16);
                        continue block21;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        continue block21;
                    }
                }
                break;
            }
            this.jj_la1[1] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{229374, 229374};
    }

    public SqlStatementInfoExtractor(InputStream stream) {
        this(stream, null);
    }

    public SqlStatementInfoExtractor(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SqlStatementInfoExtractorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SqlStatementInfoExtractor(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SqlStatementInfoExtractorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SqlStatementInfoExtractor(SqlStatementInfoExtractorTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SqlStatementInfoExtractorTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 2; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[18];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 2; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 18; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SqlStatementInfoExtractor.jj_la1_init_0();
    }

    private static class Merge
    extends Operation {
        private Merge() {
        }

        @Override
        boolean handleIdentifier(String identifier) {
            this.mainTable = identifier;
            return true;
        }
    }

    private static class Update
    extends Operation {
        private Update() {
        }

        @Override
        boolean handleIdentifier(String identifier) {
            this.mainTable = identifier;
            return true;
        }
    }

    private static class Delete
    extends Operation {
        boolean expectingTableName = false;

        private Delete() {
        }

        @Override
        boolean handleFrom() {
            this.expectingTableName = true;
            return false;
        }

        @Override
        boolean handleIdentifier(String identifier) {
            if (!this.expectingTableName) {
                return false;
            }
            this.mainTable = identifier;
            return true;
        }
    }

    private static class Insert
    extends Operation {
        boolean expectingTableName = false;

        private Insert() {
        }

        @Override
        boolean handleInto() {
            this.expectingTableName = true;
            return false;
        }

        @Override
        boolean handleIdentifier(String identifier) {
            if (!this.expectingTableName) {
                return false;
            }
            this.mainTable = identifier;
            return true;
        }
    }

    private class Select
    extends Operation {
        private static final int FROM_TABLE_REF_MAX_IDENTIFIERS = 3;
        boolean expectingTableName;
        boolean mainTableSetAlready;
        int identifiersAfterMainFromClause;

        private Select() {
            this.expectingTableName = false;
            this.mainTableSetAlready = false;
            this.identifiersAfterMainFromClause = 0;
        }

        @Override
        boolean handleFrom() {
            if (SqlStatementInfoExtractor.this.parenLevel == 0) {
                this.expectingTableName = true;
                return false;
            }
            this.mainTable = null;
            return true;
        }

        @Override
        boolean handleJoin() {
            this.mainTable = null;
            return true;
        }

        @Override
        boolean handleIdentifier(String identifier) {
            if (this.identifiersAfterMainFromClause > 0) {
                ++this.identifiersAfterMainFromClause;
            }
            if (!this.expectingTableName) {
                return false;
            }
            if (SqlStatementInfoExtractor.this.parenLevel != 0) {
                this.mainTable = null;
                return true;
            }
            if (this.mainTableSetAlready) {
                this.mainTable = null;
                return true;
            }
            this.mainTable = identifier;
            this.mainTableSetAlready = true;
            this.expectingTableName = false;
            this.identifiersAfterMainFromClause = 1;
            return false;
        }

        @Override
        boolean handleComma() {
            if (this.identifiersAfterMainFromClause > 0 && this.identifiersAfterMainFromClause <= 3) {
                this.mainTable = null;
                return true;
            }
            return false;
        }
    }

    private static class NoOp
    extends Operation {
        static final Operation INSTANCE = new NoOp();

        private NoOp() {
        }

        @Override
        SqlStatementInfo getResult(String fullStatement) {
            return new SqlStatementInfo(fullStatement, null, null);
        }
    }

    private static abstract class Operation {
        String mainTable = null;

        private Operation() {
        }

        boolean handleFrom() {
            return false;
        }

        boolean handleInto() {
            return false;
        }

        boolean handleJoin() {
            return false;
        }

        boolean handleIdentifier(String identifier) {
            return false;
        }

        boolean handleComma() {
            return false;
        }

        SqlStatementInfo getResult(String fullStatement) {
            return new SqlStatementInfo(fullStatement, this.getClass().getSimpleName().toUpperCase(), this.mainTable);
        }
    }
}

