/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.ReadOnlyArrayMap;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class ImmutableKeyValuePairs<K, V> {
    protected List<Object> data() {
        return Collections.emptyList();
    }

    public int size() {
        return this.data().size() / 2;
    }

    public boolean isEmpty() {
        return this.data().isEmpty();
    }

    public Map<K, V> asMap() {
        return ReadOnlyArrayMap.wrap(this.data());
    }

    @Nullable
    public V get(K key) {
        for (int i = 0; i < this.data().size(); i += 2) {
            if (!key.equals(this.data().get(i))) continue;
            return (V)this.data().get(i + 1);
        }
        return null;
    }

    public static List<Object> sortAndFilter(Object[] data, boolean filterNullValues) {
        return ImmutableKeyValuePairs.sortAndFilter(data, filterNullValues, Comparator.naturalOrder());
    }

    public static List<Object> sortAndFilter(Object[] data, boolean filterNullValues, Comparator<?> keyComparator) {
        Utils.checkArgument(data.length % 2 == 0, "You must provide an even number of key/value pair arguments.");
        ImmutableKeyValuePairs.mergeSort(data, keyComparator);
        return ImmutableKeyValuePairs.dedupe(data, filterNullValues, keyComparator);
    }

    private static void mergeSort(Object[] data, Comparator<?> keyComparator) {
        Object[] workArray = new Object[data.length];
        ImmutableKeyValuePairs.mergeSort(data, workArray, data.length, keyComparator);
    }

    private static void mergeSort(Object[] sourceArray, Object[] workArray, int n, Comparator<?> keyComparator) {
        System.arraycopy(sourceArray, 0, workArray, 0, sourceArray.length);
        ImmutableKeyValuePairs.splitAndMerge(workArray, 0, n, sourceArray, keyComparator);
    }

    private static void splitAndMerge(Object[] workArray, int beginIndex, int endIndex, Object[] targetArray, Comparator<?> keyComparator) {
        if (endIndex - beginIndex <= 2) {
            return;
        }
        int midpoint = (endIndex + beginIndex) / 4 * 2;
        ImmutableKeyValuePairs.splitAndMerge(targetArray, beginIndex, midpoint, workArray, keyComparator);
        ImmutableKeyValuePairs.splitAndMerge(targetArray, midpoint, endIndex, workArray, keyComparator);
        ImmutableKeyValuePairs.merge(workArray, beginIndex, midpoint, endIndex, targetArray, keyComparator);
    }

    private static <K> void merge(Object[] sourceArray, int beginIndex, int middleIndex, int endIndex, Object[] targetArray, Comparator<K> keyComparator) {
        int leftKeyIndex = beginIndex;
        int rightKeyIndex = middleIndex;
        for (int k = beginIndex; k < endIndex; k += 2) {
            if (leftKeyIndex < middleIndex - 1 && (rightKeyIndex >= endIndex - 1 || ImmutableKeyValuePairs.compareToNullSafe(sourceArray[leftKeyIndex], sourceArray[rightKeyIndex], keyComparator) <= 0)) {
                targetArray[k] = sourceArray[leftKeyIndex];
                targetArray[k + 1] = sourceArray[leftKeyIndex + 1];
                leftKeyIndex += 2;
                continue;
            }
            targetArray[k] = sourceArray[rightKeyIndex];
            targetArray[k + 1] = sourceArray[rightKeyIndex + 1];
            rightKeyIndex += 2;
        }
    }

    private static <K> int compareToNullSafe(@Nullable K key, @Nullable K pivotKey, Comparator<K> keyComparator) {
        if (key == null) {
            return pivotKey == null ? 0 : -1;
        }
        if (pivotKey == null) {
            return 1;
        }
        return keyComparator.compare(key, pivotKey);
    }

    private static <K> List<Object> dedupe(Object[] data, boolean filterNullValues, Comparator<K> keyComparator) {
        ArrayList<Object> result = new ArrayList<Object>(data.length);
        Object previousKey = null;
        for (int i = data.length - 2; i >= 0; i -= 2) {
            Object key = data[i];
            Object value = data[i + 1];
            if (key == null || previousKey != null && keyComparator.compare(key, previousKey) == 0) continue;
            previousKey = key;
            if (filterNullValues && value == null) continue;
            result.add(value);
            result.add(key);
        }
        Collections.reverse(result);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        List<Object> data = this.data();
        for (int i = 0; i < data.size(); i += 2) {
            Object value = data.get(i + 1);
            String valueStr = value instanceof String ? '\"' + (String)value + '\"' : value.toString();
            sb.append(data.get(i)).append("=").append(valueStr).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("}");
        return sb.toString();
    }
}

