/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.db;

import io.opentelemetry.javaagent.instrumentation.api.db.QueryNormalizationConfig;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class RedisCommandNormalizer {
    private static final Map<String, CommandNormalizer> NORMALIZERS;
    private static final CommandNormalizer DEFAULT;
    private final boolean normalizationEnabled;

    public RedisCommandNormalizer(String ... instrumentationNames) {
        this(QueryNormalizationConfig.isQueryNormalizationEnabled(instrumentationNames));
    }

    RedisCommandNormalizer(boolean normalizationEnabled) {
        this.normalizationEnabled = normalizationEnabled;
    }

    public String normalize(String command, List<?> args) {
        if (!this.normalizationEnabled) {
            return CommandNormalizer.KeepAllArgs.INSTANCE.normalize(command, args);
        }
        return NORMALIZERS.getOrDefault(command.toUpperCase(), DEFAULT).normalize(command, args);
    }

    static {
        DEFAULT = new CommandNormalizer.CommandAndNumArgs(0);
        HashMap<String, CommandNormalizer> normalizers = new HashMap<String, CommandNormalizer>();
        CommandNormalizer.CommandAndNumArgs keepOneArg = new CommandNormalizer.CommandAndNumArgs(1);
        CommandNormalizer.CommandAndNumArgs keepTwoArgs = new CommandNormalizer.CommandAndNumArgs(2);
        CommandNormalizer.MultiKeyValue setMultiHashField = new CommandNormalizer.MultiKeyValue(1);
        CommandNormalizer.MultiKeyValue setMultiField = new CommandNormalizer.MultiKeyValue(0);
        for (String command : Arrays.asList("CLUSTER", "READONLY", "READWRITE")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        normalizers.put("AUTH", DEFAULT);
        normalizers.put("HELLO", keepTwoArgs);
        for (String command : Arrays.asList("CLIENT", "ECHO", "PING", "QUIT", "SELECT")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        for (String command : Arrays.asList("GEOADD", "GEODIST", "GEOHASH", "GEOPOS", "GEORADIUS", "GEORADIUSBYMEMBER")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        normalizers.put("HMSET", setMultiHashField);
        normalizers.put("HSET", setMultiHashField);
        normalizers.put("HSETNX", keepTwoArgs);
        for (String command : Arrays.asList("HDEL", "HEXISTS", "HGET", "HGETALL", "HINCRBY", "HINCRBYFLOAT", "HKEYS", "HLEN", "HMGET", "HSCAN", "HSTRLEN", "HVALS")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        normalizers.put("PFADD", keepOneArg);
        for (String command : Arrays.asList("PFCOUNT", "PFMERGE")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        normalizers.put("MIGRATE", new CommandNormalizer.CommandAndNumArgs(6));
        normalizers.put("RESTORE", keepTwoArgs);
        for (String command : Arrays.asList("DEL", "DUMP", "EXISTS", "EXPIRE", "EXPIREAT", "KEYS", "MOVE", "OBJECT", "PERSIST", "PEXPIRE", "PEXPIREAT", "PTTL", "RANDOMKEY", "RENAME", "RENAMENX", "SCAN", "SORT", "TOUCH", "TTL", "TYPE", "UNLINK", "WAIT")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        normalizers.put("LINSERT", keepTwoArgs);
        normalizers.put("LPOS", keepOneArg);
        normalizers.put("LPUSH", keepOneArg);
        normalizers.put("LPUSHX", keepOneArg);
        normalizers.put("LREM", keepOneArg);
        normalizers.put("LSET", keepOneArg);
        normalizers.put("RPUSH", keepOneArg);
        normalizers.put("RPUSHX", keepOneArg);
        for (String command : Arrays.asList("BLMOVE", "BLPOP", "BRPOP", "BRPOPLPUSH", "LINDEX", "LLEN", "LMOVE", "LPOP", "LRANGE", "LTRIM", "RPOP", "RPOPLPUSH")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        normalizers.put("PUBLISH", keepOneArg);
        for (String command : Arrays.asList("PSUBSCRIBE", "PUBSUB", "PUNSUBSCRIBE", "SUBSCRIBE", "UNSUBSCRIBE")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        normalizers.put("EVAL", CommandNormalizer.Eval.INSTANCE);
        normalizers.put("EVALSHA", CommandNormalizer.Eval.INSTANCE);
        normalizers.put("SCRIPT", CommandNormalizer.KeepAllArgs.INSTANCE);
        normalizers.put("CONFIG", keepTwoArgs);
        for (String command : Arrays.asList("ACL", "BGREWRITEAOF", "BGSAVE", "COMMAND", "DBSIZE", "DEBUG", "FLUSHALL", "FLUSHDB", "INFO", "LASTSAVE", "LATENCY", "LOLWUT", "MEMORY", "MODULE", "MONITOR", "PSYNC", "REPLICAOF", "ROLE", "SAVE", "SHUTDOWN", "SLAVEOF", "SLOWLOG", "SWAPDB", "SYNC", "TIME")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        normalizers.put("SADD", keepOneArg);
        normalizers.put("SISMEMBER", keepOneArg);
        normalizers.put("SMISMEMBER", keepOneArg);
        normalizers.put("SMOVE", keepTwoArgs);
        normalizers.put("SREM", keepOneArg);
        for (String command : Arrays.asList("SCARD", "SDIFF", "SDIFFSTORE", "SINTER", "SINTERSTORE", "SMEMBERS", "SPOP", "SRANDMEMBER", "SSCAN", "SUNION", "SUNIONSTORE")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        normalizers.put("ZADD", keepOneArg);
        normalizers.put("ZCOUNT", keepOneArg);
        normalizers.put("ZINCRBY", keepOneArg);
        normalizers.put("ZLEXCOUNT", keepOneArg);
        normalizers.put("ZMSCORE", keepOneArg);
        normalizers.put("ZRANGEBYLEX", keepOneArg);
        normalizers.put("ZRANGEBYSCORE", keepOneArg);
        normalizers.put("ZRANK", keepOneArg);
        normalizers.put("ZREM", keepOneArg);
        normalizers.put("ZREMRANGEBYLEX", keepOneArg);
        normalizers.put("ZREMRANGEBYSCORE", keepOneArg);
        normalizers.put("ZREVRANGEBYLEX", keepOneArg);
        normalizers.put("ZREVRANGEBYSCORE", keepOneArg);
        normalizers.put("ZREVRANK", keepOneArg);
        normalizers.put("ZSCORE", keepOneArg);
        for (String command : Arrays.asList("BZPOPMAX", "BZPOPMIN", "ZCARD", "ZINTER", "ZINTERSTORE", "ZPOPMAX", "ZPOPMIN", "ZRANGE", "ZREMRANGEBYRANK", "ZREVRANGE", "ZSCAN", "ZUNION", "ZUNIONSTORE")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        normalizers.put("XADD", new CommandNormalizer.MultiKeyValue(2));
        for (String command : Arrays.asList("XACK", "XCLAIM", "XDEL", "XGROUP", "XINFO", "XLEN", "XPENDING", "XRANGE", "XREAD", "XREADGROUP", "XREVRANGE", "XTRIM")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        normalizers.put("APPEND", keepOneArg);
        normalizers.put("GETSET", keepOneArg);
        normalizers.put("MSET", setMultiField);
        normalizers.put("MSETNX", setMultiField);
        normalizers.put("PSETEX", keepTwoArgs);
        normalizers.put("SET", keepOneArg);
        normalizers.put("SETEX", keepTwoArgs);
        normalizers.put("SETNX", keepOneArg);
        normalizers.put("SETRANGE", keepOneArg);
        for (String command : Arrays.asList("BITCOUNT", "BITFIELD", "BITOP", "BITPOS", "DECR", "DECRBY", "GET", "GETBIT", "GETRANGE", "INCR", "INCRBY", "INCRBYFLOAT", "MGET", "SETBIT", "STRALGO", "STRLEN")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        for (String command : Arrays.asList("DISCARD", "EXEC", "MULTI", "UNWATCH", "WATCH")) {
            normalizers.put(command, CommandNormalizer.KeepAllArgs.INSTANCE);
        }
        NORMALIZERS = Collections.unmodifiableMap(normalizers);
    }

    public static interface CommandNormalizer {
        public String normalize(String var1, List<?> var2);

        public static String argToString(Object arg) {
            if (arg instanceof byte[]) {
                return new String((byte[])arg, StandardCharsets.UTF_8);
            }
            return arg.toString();
        }

        public static enum Eval implements CommandNormalizer
        {
            INSTANCE;


            @Override
            public String normalize(String command, List<?> args) {
                int i;
                StringBuilder normalised = new StringBuilder(command);
                int numberOfKeys = 0;
                if (args.size() > 2) {
                    try {
                        numberOfKeys = Integer.parseInt(CommandNormalizer.argToString(args.get(1)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                for (i = 0; i < numberOfKeys + 2 && i < args.size(); ++i) {
                    normalised.append(" ").append(CommandNormalizer.argToString(args.get(i)));
                }
                while (i < args.size()) {
                    normalised.append(" ?");
                    ++i;
                }
                return normalised.toString();
            }
        }

        public static class MultiKeyValue
        implements CommandNormalizer {
            private final int numOfArgsBeforeKeyValue;

            public MultiKeyValue(int numOfArgsBeforeKeyValue) {
                this.numOfArgsBeforeKeyValue = numOfArgsBeforeKeyValue;
            }

            @Override
            public String normalize(String command, List<?> args) {
                int i;
                StringBuilder normalised = new StringBuilder(command);
                for (i = 0; i < this.numOfArgsBeforeKeyValue && i < args.size(); ++i) {
                    normalised.append(" ").append(CommandNormalizer.argToString(args.get(i)));
                }
                for (i = this.numOfArgsBeforeKeyValue; i < args.size(); i += 2) {
                    normalised.append(" ").append(CommandNormalizer.argToString(args.get(i))).append(" ?");
                }
                return normalised.toString();
            }
        }

        public static class CommandAndNumArgs
        implements CommandNormalizer {
            private final int numOfArgsToKeep;

            public CommandAndNumArgs(int numOfArgsToKeep) {
                this.numOfArgsToKeep = numOfArgsToKeep;
            }

            @Override
            public String normalize(String command, List<?> args) {
                int i;
                StringBuilder normalised = new StringBuilder(command);
                for (i = 0; i < this.numOfArgsToKeep && i < args.size(); ++i) {
                    normalised.append(" ").append(CommandNormalizer.argToString(args.get(i)));
                }
                for (i = this.numOfArgsToKeep; i < args.size(); ++i) {
                    normalised.append(" ?");
                }
                return normalised.toString();
            }
        }

        public static enum KeepAllArgs implements CommandNormalizer
        {
            INSTANCE;


            @Override
            public String normalize(String command, List<?> args) {
                StringBuilder normalised = new StringBuilder(command);
                for (Object arg : args) {
                    normalised.append(" ").append(CommandNormalizer.argToString(arg));
                }
                return normalised.toString();
            }
        }
    }
}

