/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.ArrayBackedAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class ArrayBackedAttributesBuilder
implements AttributesBuilder {
    private final List<Object> data;

    ArrayBackedAttributesBuilder() {
        this.data = new ArrayList<Object>();
    }

    ArrayBackedAttributesBuilder(List<Object> data) {
        this.data = data;
    }

    @Override
    public Attributes build() {
        return ArrayBackedAttributes.sortAndFilterToAttributes(this.data.toArray());
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<Long> key, int value) {
        return this.put(key, Long.valueOf(value));
    }

    @Override
    public <T> AttributesBuilder put(AttributeKey<T> key, T value) {
        if (key == null || key.getKey() == null || key.getKey().length() == 0 || value == null) {
            return this;
        }
        this.data.add(key);
        this.data.add(value);
        return this;
    }

    @Override
    public AttributesBuilder put(String key, String value) {
        return this.put(AttributeKey.stringKey(key), value);
    }

    @Override
    public AttributesBuilder put(String key, long value) {
        return this.put(AttributeKey.longKey(key), Long.valueOf(value));
    }

    @Override
    public AttributesBuilder put(String key, double value) {
        return this.put(AttributeKey.doubleKey(key), Double.valueOf(value));
    }

    @Override
    public AttributesBuilder put(String key, boolean value) {
        return this.put(AttributeKey.booleanKey(key), Boolean.valueOf(value));
    }

    @Override
    public AttributesBuilder put(String key, String ... value) {
        return this.put(AttributeKey.stringArrayKey(key), value == null ? null : Arrays.asList(value));
    }

    @Override
    public AttributesBuilder put(String key, long ... value) {
        return this.put(AttributeKey.longArrayKey(key), value == null ? null : ArrayBackedAttributesBuilder.toList(value));
    }

    @Override
    public AttributesBuilder put(String key, double ... value) {
        return this.put(AttributeKey.doubleArrayKey(key), value == null ? null : ArrayBackedAttributesBuilder.toList(value));
    }

    @Override
    public AttributesBuilder put(String key, boolean ... value) {
        return this.put(AttributeKey.booleanArrayKey(key), value == null ? null : ArrayBackedAttributesBuilder.toList(value));
    }

    @Override
    public AttributesBuilder putAll(Attributes attributes) {
        attributes.forEach((key, value) -> this.put((AttributeKey)key, (Object)value));
        return this;
    }

    private static List<Double> toList(double ... values) {
        Double[] boxed = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    private static List<Long> toList(long ... values) {
        Long[] boxed = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }

    private static List<Boolean> toList(boolean ... values) {
        Boolean[] boxed = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            boxed[i] = values[i];
        }
        return Arrays.asList(boxed);
    }
}

