/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.ignore;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesBuilder;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesConfigurer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.Collections;
import java.util.List;

@AutoService(value={IgnoredTypesConfigurer.class})
public class UserExcludedClassLoadersConfigurer
implements IgnoredTypesConfigurer {
    static final String EXCLUDED_CLASS_LOADERS_CONFIG = "otel.javaagent.exclude-class-loaders";

    public void configure(IgnoredTypesBuilder builder, ConfigProperties config) {
        List excludedClassLoaders = config.getList(EXCLUDED_CLASS_LOADERS_CONFIG, Collections.emptyList());
        for (String excludedClassLoader : excludedClassLoaders) {
            if ((excludedClassLoader = excludedClassLoader.trim()).endsWith("*")) {
                excludedClassLoader = excludedClassLoader.substring(0, excludedClassLoader.length() - 1);
            }
            builder.ignoreClassLoader(excludedClassLoader);
        }
    }
}

