/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.AdviceTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

class VirtualFieldChecker {
    private static final Type VIRTUAL_FIELD_TYPE = Type.getType(VirtualField.class);

    static void check(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 6);
        String dotClassName = Type.getObjectType((String)classNode.name).getClassName();
        classNode.methods.forEach(m -> VirtualFieldChecker.checkMethod(m, dotClassName));
    }

    private static void checkMethod(final MethodNode methodNode, final String dotClassName) {
        if (!AdviceTransformer.hasAnnotation(methodNode, AdviceTransformer.ADVICE_ON_METHOD_ENTER) && !AdviceTransformer.hasAnnotation(methodNode, AdviceTransformer.ADVICE_ON_METHOD_EXIT)) {
            return;
        }
        methodNode.accept(new MethodVisitor(589824, null){

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                if (opcode == 184 && VIRTUAL_FIELD_TYPE.getInternalName().equals(owner) && "find".equals(name)) {
                    throw new IllegalStateException("Found usage of VirtualField.find in advice " + dotClassName + "." + methodNode.name);
                }
            }
        });
    }

    private VirtualFieldChecker() {
    }
}

