/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationValue;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ForceDynamicallyTypedAssignReturnedFactory
implements Advice.PostProcessor.Factory {
    private static final String TO_ARGUMENTS_TYPENAME = Advice.AssignReturned.ToArguments.class.getName();
    private static final String TO_ARGUMENT_TYPENAME = Advice.AssignReturned.ToArguments.ToArgument.class.getName();
    private static final String TO_ALL_ARGUMENTS_TYPENAME = Advice.AssignReturned.ToAllArguments.class.getName();
    private static final String TO_THIS_TYPENAME = Advice.AssignReturned.ToThis.class.getName();
    private static final String TO_FIELDS_TYPENAME = Advice.AssignReturned.ToFields.class.getName();
    private static final String TO_FIELD_TYPENAME = Advice.AssignReturned.ToFields.ToField.class.getName();
    private static final String TO_RETURNED_TYPENAME = Advice.AssignReturned.ToReturned.class.getName();
    private static final String TO_THROWN_TYPENAME = Advice.AssignReturned.ToThrown.class.getName();
    private static final EnumerationDescription DYNAMIC_TYPING = new EnumerationDescription.ForLoadedEnumeration((Enum)Assigner.Typing.DYNAMIC);
    private final Advice.PostProcessor.Factory delegate;

    public ForceDynamicallyTypedAssignReturnedFactory(Advice.PostProcessor.Factory delegate) {
        this.delegate = delegate;
    }

    public Advice.PostProcessor make(MethodDescription.InDefinedShape adviceMethod, boolean exit) {
        return this.delegate.make(ForceDynamicallyTypedAssignReturnedFactory.forceDynamicTyping(adviceMethod), exit);
    }

    static MethodDescription.InDefinedShape forceDynamicTyping(MethodDescription.InDefinedShape adviceMethod) {
        return new MethodDescription.Latent(adviceMethod.getDeclaringType(), adviceMethod.getInternalName(), adviceMethod.getModifiers(), (List)adviceMethod.getTypeVariables().asTokenList((ElementMatcher)ElementMatchers.none()), adviceMethod.getReturnType(), (List)adviceMethod.getParameters().asTokenList((ElementMatcher)ElementMatchers.none()), (List)adviceMethod.getExceptionTypes(), ForceDynamicallyTypedAssignReturnedFactory.forceDynamicTyping((List<? extends AnnotationDescription>)adviceMethod.getDeclaredAnnotations()), adviceMethod.getDefaultValue(), adviceMethod.getReceiverType());
    }

    private static List<? extends AnnotationDescription> forceDynamicTyping(List<? extends AnnotationDescription> declaredAnnotations) {
        return declaredAnnotations.stream().map(ForceDynamicallyTypedAssignReturnedFactory::forceDynamicTyping).collect(Collectors.toList());
    }

    private static AnnotationDescription forceDynamicTyping(AnnotationDescription anno) {
        String name = anno.getAnnotationType().getName();
        if (name.equals(TO_FIELD_TYPENAME) || name.equals(TO_ARGUMENT_TYPENAME) || name.equals(TO_THIS_TYPENAME) || name.equals(TO_ALL_ARGUMENTS_TYPENAME) || name.equals(TO_RETURNED_TYPENAME) || name.equals(TO_THROWN_TYPENAME)) {
            return ForceDynamicallyTypedAssignReturnedFactory.replaceAnnotationValue(anno, "typing", oldVal -> AnnotationValue.ForEnumerationDescription.of((EnumerationDescription)DYNAMIC_TYPING));
        }
        if (name.equals(TO_FIELDS_TYPENAME) || name.equals(TO_ARGUMENTS_TYPENAME)) {
            return ForceDynamicallyTypedAssignReturnedFactory.replaceAnnotationValue(anno, "value", oldVal -> {
                if (!oldVal.getState().isDefined()) {
                    return null;
                }
                AnnotationDescription[] resolve = (AnnotationDescription[])oldVal.resolve();
                if (resolve.length == 0) {
                    return oldVal;
                }
                AnnotationDescription[] newValueList = (AnnotationDescription[])Arrays.stream(resolve).map(ForceDynamicallyTypedAssignReturnedFactory::forceDynamicTyping).toArray(AnnotationDescription[]::new);
                TypeDescription subType = newValueList[0].getAnnotationType();
                return AnnotationValue.ForDescriptionArray.of((TypeDescription)subType, (AnnotationDescription[])newValueList);
            });
        }
        return anno;
    }

    private static AnnotationDescription replaceAnnotationValue(AnnotationDescription anno, String propertyName, Function<AnnotationValue<?, ?>, AnnotationValue<?, ?>> valueMapper) {
        AnnotationValue oldValue = anno.getValue(propertyName);
        AnnotationValue<?, ?> newValue = valueMapper.apply(oldValue);
        HashMap<String, Object> updatedValues = new HashMap<String, Object>();
        for (MethodDescription.InDefinedShape property : anno.getAnnotationType().getDeclaredMethods()) {
            AnnotationValue value = anno.getValue(property);
            if (propertyName.equals(property.getName()) || !value.getState().isDefined()) continue;
            updatedValues.put(property.getName(), value);
        }
        if (newValue != null) {
            updatedValues.put(propertyName, newValue);
        }
        return new AnnotationDescription.Latent(anno.getAnnotationType(), updatedValues){};
    }
}

