/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.config;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.config.ConfigParsingException;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ConfigPropertiesAdapter
implements ConfigProperties {
    private final Config config;

    public ConfigPropertiesAdapter(Config config) {
        this.config = config;
    }

    public @Nullable String getString(String name) {
        return this.config.getString(name);
    }

    public @Nullable Boolean getBoolean(String name) {
        return this.config.getBoolean(name);
    }

    public @Nullable Integer getInt(String name) {
        try {
            return this.config.getInt(name);
        }
        catch (ConfigParsingException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public @Nullable Long getLong(String name) {
        try {
            return this.config.getLong(name);
        }
        catch (ConfigParsingException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public @Nullable Double getDouble(String name) {
        try {
            return this.config.getDouble(name);
        }
        catch (ConfigParsingException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public @Nullable Duration getDuration(String name) {
        try {
            return this.config.getDuration(name);
        }
        catch (ConfigParsingException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }

    public List<String> getList(String name) {
        return this.config.getList(name);
    }

    public Map<String, String> getMap(String name) {
        try {
            return this.config.getMap(name);
        }
        catch (ConfigParsingException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
    }
}

