/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.matcher;

import io.opentelemetry.instrumentation.api.caching.Cache;
import io.opentelemetry.javaagent.extension.muzzle.ClassRef;
import io.opentelemetry.javaagent.extension.muzzle.FieldRef;
import io.opentelemetry.javaagent.extension.muzzle.Flag;
import io.opentelemetry.javaagent.extension.muzzle.MethodRef;
import io.opentelemetry.javaagent.tooling.AgentTooling;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationClassPredicate;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.HelperReferenceWrapper;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.Mismatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.pool.TypePool;

public final class ReferenceMatcher {
    private final Cache<ClassLoader, Boolean> mismatchCache = Cache.newBuilder().setWeakKeys().build();
    private final Map<String, ClassRef> references;
    private final Set<String> helperClassNames;
    private final InstrumentationClassPredicate instrumentationClassPredicate;

    public ReferenceMatcher(List<String> helperClassNames, Map<String, ClassRef> references, Predicate<String> libraryInstrumentationPredicate) {
        this.references = references;
        this.helperClassNames = new HashSet<String>(helperClassNames);
        this.instrumentationClassPredicate = new InstrumentationClassPredicate(libraryInstrumentationPredicate);
    }

    public boolean matches(ClassLoader userClassLoader) {
        return (Boolean)this.mismatchCache.computeIfAbsent((Object)userClassLoader, this::doesMatch);
    }

    private boolean doesMatch(ClassLoader loader) {
        TypePool typePool = ReferenceMatcher.createTypePool(loader);
        for (ClassRef reference : this.references.values()) {
            if (this.checkMatch(reference, typePool, loader).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<Mismatch> getMismatchedReferenceSources(ClassLoader loader) {
        TypePool typePool = ReferenceMatcher.createTypePool(loader);
        List<Mismatch> mismatches = Collections.emptyList();
        for (ClassRef reference : this.references.values()) {
            mismatches = ReferenceMatcher.lazyAddAll(mismatches, this.checkMatch(reference, typePool, loader));
        }
        return mismatches;
    }

    private static TypePool createTypePool(ClassLoader loader) {
        return AgentTooling.poolStrategy().typePool(AgentTooling.locationStrategy().classFileLocator(loader), loader);
    }

    private List<Mismatch> checkMatch(ClassRef reference, TypePool typePool, ClassLoader loader) {
        try {
            if (this.instrumentationClassPredicate.isInstrumentationClass(reference.getClassName())) {
                if (!this.helperClassNames.contains(reference.getClassName())) {
                    return Collections.singletonList(new Mismatch.MissingClass(reference));
                }
                return this.checkHelperClassMatch(reference, typePool);
            }
            TypePool.Resolution resolution = typePool.describe(reference.getClassName());
            if (!resolution.isResolved()) {
                return Collections.singletonList(new Mismatch.MissingClass(reference));
            }
            return ReferenceMatcher.checkThirdPartyTypeMatch(reference, resolution.resolve());
        }
        catch (RuntimeException e) {
            if (e.getMessage().startsWith("Cannot resolve type description for ")) {
                String className = e.getMessage().replace("Cannot resolve type description for ", "");
                return Collections.singletonList(new Mismatch.MissingClass(reference, className));
            }
            return Collections.singletonList(new Mismatch.ReferenceCheckError(e, reference, loader));
        }
    }

    private List<Mismatch> checkHelperClassMatch(ClassRef helperClass, TypePool typePool) {
        List<Mismatch> mismatches = Collections.emptyList();
        HelperReferenceWrapper helperWrapper = new HelperReferenceWrapper.Factory(typePool, this.references).create(helperClass);
        Set undeclaredFields = helperClass.getFields().stream().filter(f -> !f.isDeclared()).map(f -> new HelperReferenceWrapper.Field(f.getName(), f.getDescriptor())).collect(Collectors.toSet());
        if (!undeclaredFields.isEmpty()) {
            HashSet<HelperReferenceWrapper.Field> superClassFields = new HashSet<HelperReferenceWrapper.Field>();
            ReferenceMatcher.collectFieldsFromTypeHierarchy(helperWrapper, superClassFields);
            undeclaredFields.removeAll(superClassFields);
            for (HelperReferenceWrapper.Field missingField : undeclaredFields) {
                mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingField(helperClass, missingField));
            }
        }
        if (!helperWrapper.hasSuperTypes() || helperWrapper.isAbstract()) {
            return mismatches;
        }
        HashSet<HelperReferenceWrapper.Method> abstractMethods = new HashSet<HelperReferenceWrapper.Method>();
        HashSet<HelperReferenceWrapper.Method> plainMethods = new HashSet<HelperReferenceWrapper.Method>();
        ReferenceMatcher.collectMethodsFromTypeHierarchy(helperWrapper, abstractMethods, plainMethods);
        abstractMethods.removeAll(plainMethods);
        for (HelperReferenceWrapper.Method unimplementedMethod : abstractMethods) {
            mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingMethod(helperClass, unimplementedMethod));
        }
        return mismatches;
    }

    private static void collectFieldsFromTypeHierarchy(HelperReferenceWrapper type, Set<HelperReferenceWrapper.Field> fields) {
        type.getFields().forEach(fields::add);
        type.getSuperTypes().forEach(superType -> ReferenceMatcher.collectFieldsFromTypeHierarchy(superType, fields));
    }

    private static void collectMethodsFromTypeHierarchy(HelperReferenceWrapper type, Set<HelperReferenceWrapper.Method> abstractMethods, Set<HelperReferenceWrapper.Method> plainMethods) {
        type.getMethods().forEach(method -> (method.isAbstract() ? abstractMethods : plainMethods).add(method));
        type.getSuperTypes().forEach(superType -> ReferenceMatcher.collectMethodsFromTypeHierarchy(superType, abstractMethods, plainMethods));
    }

    private static List<Mismatch> checkThirdPartyTypeMatch(ClassRef reference, TypeDescription typeOnClasspath) {
        String desc;
        List<Mismatch> mismatches = Collections.emptyList();
        for (Flag flag : reference.getFlags()) {
            if (flag.matches(typeOnClasspath.getActualModifiers(false))) continue;
            String desc2 = reference.getClassName();
            mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingFlag(reference.getSources(), desc2, flag, typeOnClasspath.getActualModifiers(false)));
        }
        for (FieldRef fieldRef : reference.getFields()) {
            FieldDescription.InDefinedShape fieldDescription = ReferenceMatcher.findField(fieldRef, typeOnClasspath);
            if (fieldDescription == null) {
                mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingField(reference, fieldRef));
                continue;
            }
            for (Flag flag : fieldRef.getFlags()) {
                if (flag.matches(fieldDescription.getModifiers())) continue;
                desc = reference.getClassName() + "#" + fieldRef.getName() + Type.getType((String)fieldRef.getDescriptor()).getInternalName();
                mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingFlag(fieldRef.getSources(), desc, flag, fieldDescription.getModifiers()));
            }
        }
        for (MethodRef methodRef : reference.getMethods()) {
            MethodDescription.InDefinedShape methodDescription = ReferenceMatcher.findMethod(methodRef, typeOnClasspath);
            if (methodDescription == null) {
                mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingMethod(reference, methodRef));
                continue;
            }
            for (Flag flag : methodRef.getFlags()) {
                if (flag.matches(methodDescription.getModifiers())) continue;
                desc = reference.getClassName() + "#" + methodRef.getName() + methodRef.getDescriptor();
                mismatches = ReferenceMatcher.lazyAdd(mismatches, new Mismatch.MissingFlag(methodRef.getSources(), desc, flag, methodDescription.getModifiers()));
            }
        }
        return mismatches;
    }

    private static FieldDescription.InDefinedShape findField(FieldRef fieldRef, TypeDescription typeOnClasspath) {
        FieldDescription.InDefinedShape fieldOnSupertype;
        for (FieldDescription.InDefinedShape fieldType : typeOnClasspath.getDeclaredFields()) {
            if (!fieldType.getName().equals(fieldRef.getName()) || !fieldType.getDescriptor().equals(fieldRef.getDescriptor())) continue;
            return fieldType;
        }
        if (typeOnClasspath.getSuperClass() != null && (fieldOnSupertype = ReferenceMatcher.findField(fieldRef, typeOnClasspath.getSuperClass().asErasure())) != null) {
            return fieldOnSupertype;
        }
        for (TypeDescription.Generic interfaceType : typeOnClasspath.getInterfaces()) {
            FieldDescription.InDefinedShape fieldOnSupertype2 = ReferenceMatcher.findField(fieldRef, interfaceType.asErasure());
            if (fieldOnSupertype2 == null) continue;
            return fieldOnSupertype2;
        }
        return null;
    }

    private static MethodDescription.InDefinedShape findMethod(MethodRef methodRef, TypeDescription typeOnClasspath) {
        MethodDescription.InDefinedShape methodOnSupertype;
        for (MethodDescription.InDefinedShape methodDescription : typeOnClasspath.getDeclaredMethods()) {
            if (!methodDescription.getInternalName().equals(methodRef.getName()) || !methodDescription.getDescriptor().equals(methodRef.getDescriptor())) continue;
            return methodDescription;
        }
        if (typeOnClasspath.getSuperClass() != null && (methodOnSupertype = ReferenceMatcher.findMethod(methodRef, typeOnClasspath.getSuperClass().asErasure())) != null) {
            return methodOnSupertype;
        }
        for (TypeDescription.Generic interfaceType : typeOnClasspath.getInterfaces()) {
            MethodDescription.InDefinedShape methodOnSupertype2 = ReferenceMatcher.findMethod(methodRef, interfaceType.asErasure());
            if (methodOnSupertype2 == null) continue;
            return methodOnSupertype2;
        }
        return null;
    }

    private static List<Mismatch> lazyAdd(List<Mismatch> mismatches, Mismatch mismatch) {
        ArrayList<Mismatch> result = mismatches.isEmpty() ? new ArrayList<Mismatch>() : mismatches;
        result.add(mismatch);
        return result;
    }

    private static List<Mismatch> lazyAddAll(List<Mismatch> mismatches, List<Mismatch> toAdd) {
        if (!toAdd.isEmpty()) {
            ArrayList<Mismatch> result = mismatches.isEmpty() ? new ArrayList<Mismatch>() : mismatches;
            result.addAll(toAdd);
            return result;
        }
        return mismatches;
    }
}

