/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.ClassCopySource;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.InstrumentationModuleClassLoader;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;

public class IndyModuleRegistry {
    private static final ConcurrentHashMap<String, InstrumentationModule> modulesByName = new ConcurrentHashMap();
    private static final ConcurrentHashMap<InstrumentationModule, Cache<ClassLoader, WeakReference<InstrumentationModuleClassLoader>>> instrumentationClassloaders = new ConcurrentHashMap();
    private static final ClassLoader BOOT_LOADER = new ClassLoader(){};

    private IndyModuleRegistry() {
    }

    public static InstrumentationModuleClassLoader getInstrumentationClassloader(String moduleClassName, ClassLoader instrumentedClassloader) {
        InstrumentationModule instrumentationModule = modulesByName.get(moduleClassName);
        if (instrumentationModule == null) {
            throw new IllegalArgumentException("No module with the class name " + modulesByName + " has been registered!");
        }
        return IndyModuleRegistry.getInstrumentationClassloader(instrumentationModule, instrumentedClassloader);
    }

    private static synchronized InstrumentationModuleClassLoader getInstrumentationClassloader(InstrumentationModule module, ClassLoader instrumentedClassloader) {
        InstrumentationModuleClassLoader cachedCl;
        Cache cacheForModule = instrumentationClassloaders.computeIfAbsent(module, k -> Cache.weak());
        WeakReference cached = (WeakReference)cacheForModule.get((Object)(instrumentedClassloader = IndyModuleRegistry.maskNullClassLoader(instrumentedClassloader)));
        if (cached != null && (cachedCl = (InstrumentationModuleClassLoader)cached.get()) != null) {
            return cachedCl;
        }
        InstrumentationModuleClassLoader created = IndyModuleRegistry.createInstrumentationModuleClassloader(module, instrumentedClassloader);
        cacheForModule.put((Object)instrumentedClassloader, new WeakReference<InstrumentationModuleClassLoader>(created));
        return created;
    }

    private static ClassLoader maskNullClassLoader(ClassLoader classLoader) {
        return classLoader == null ? BOOT_LOADER : classLoader;
    }

    private static InstrumentationModuleClassLoader createInstrumentationModuleClassloader(InstrumentationModule module, ClassLoader instrumentedClassloader) {
        HashSet<String> toInject = new HashSet<String>(InstrumentationModuleMuzzle.getHelperClassNames((InstrumentationModule)module));
        toInject.addAll(IndyModuleRegistry.getModuleAdviceNames(module));
        ClassLoader agentOrExtensionCl = module.getClass().getClassLoader();
        Map<String, ClassCopySource> injectedClasses = toInject.stream().collect(Collectors.toMap(name -> name, name -> ClassCopySource.create(name, agentOrExtensionCl)));
        return new InstrumentationModuleClassLoader(instrumentedClassloader, agentOrExtensionCl, injectedClasses);
    }

    public static void registerIndyModule(InstrumentationModule module) {
        if (!module.isIndyModule()) {
            throw new IllegalArgumentException("Provided module is not an indy module!");
        }
        String moduleName = module.getClass().getName();
        if (modulesByName.putIfAbsent(moduleName, module) != null) {
            throw new IllegalArgumentException("A module with the class name " + moduleName + " has already been registered!");
        }
    }

    private static Set<String> getModuleAdviceNames(InstrumentationModule module) {
        final HashSet<String> adviceNames = new HashSet<String>();
        TypeTransformer nameCollector = new TypeTransformer(){

            public void applyAdviceToMethod(ElementMatcher<? super MethodDescription> methodMatcher, String adviceClassName) {
                adviceNames.add(adviceClassName);
            }

            public void applyTransformer(AgentBuilder.Transformer transformer) {
            }
        };
        for (TypeInstrumentation instr : module.typeInstrumentations()) {
            instr.transform(nameCollector);
        }
        return adviceNames;
    }
}

