/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.bootstrap.IndyBootstrapDispatcher;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.IndyModuleRegistry;
import io.opentelemetry.javaagent.tooling.instrumentation.indy.InstrumentationModuleClassLoader;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.utility.JavaConstant;

public class IndyBootstrap {
    private static final Logger logger = Logger.getLogger(IndyBootstrap.class.getName());
    private static final Method indyBootstrapMethod;

    private IndyBootstrap() {
    }

    public static Method getIndyBootstrapMethod() {
        return indyBootstrapMethod;
    }

    @Nullable
    private static ConstantCallSite bootstrap(MethodHandles.Lookup lookup, String adviceMethodName, MethodType adviceMethodType, Object[] args) {
        if (System.getSecurityManager() == null) {
            return IndyBootstrap.internalBootstrap(lookup, adviceMethodName, adviceMethodType, args);
        }
        return AccessController.doPrivileged(() -> IndyBootstrap.internalBootstrap(lookup, adviceMethodName, adviceMethodType, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConstantCallSite internalBootstrap(MethodHandles.Lookup lookup, String adviceMethodName, MethodType adviceMethodType, Object[] args) {
        CallDepth callDepth = CallDepth.forClass(IndyBootstrap.class);
        try {
            if (callDepth.getAndIncrement() > 0) {
                logger.log(Level.WARNING, "Nested instrumented invokedynamic instruction linkage detected", new Throwable());
                ConstantCallSite constantCallSite = null;
                return constantCallSite;
            }
            String moduleClassName = (String)args[0];
            String adviceClassName = (String)args[1];
            InstrumentationModuleClassLoader instrumentationClassloader = IndyModuleRegistry.getInstrumentationClassloader(moduleClassName, lookup.lookupClass().getClassLoader());
            Class<?> adviceClass = instrumentationClassloader.loadClass(adviceClassName);
            MethodHandle methodHandle = instrumentationClassloader.getLookup().findStatic(adviceClass, adviceMethodName, adviceMethodType);
            ConstantCallSite constantCallSite = new ConstantCallSite(methodHandle);
            return constantCallSite;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            ConstantCallSite constantCallSite = null;
            return constantCallSite;
        }
        finally {
            callDepth.decrementAndGet();
        }
    }

    static Advice.BootstrapArgumentResolver.Factory getAdviceBootstrapArguments(InstrumentationModule instrumentationModule) {
        String moduleName = instrumentationModule.getClass().getName();
        return (adviceMethod, exit) -> (instrumentedType, instrumentedMethod) -> Arrays.asList(JavaConstant.Simple.ofLoaded((Object)moduleName), JavaConstant.Simple.ofLoaded((Object)adviceMethod.getDeclaringType().getName()));
    }

    static {
        try {
            indyBootstrapMethod = IndyBootstrapDispatcher.class.getMethod("bootstrap", MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class);
            MethodType bootstrapMethodType = MethodType.methodType(ConstantCallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Object[].class);
            IndyBootstrapDispatcher.init((MethodHandle)MethodHandles.lookup().findStatic(IndyBootstrap.class, "bootstrap", bootstrapMethodType));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

