/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.bytebuddy.utility.StreamDrainer;

abstract class ClassCopySource {
    private ClassCopySource() {
    }

    public abstract URL getUrl();

    public abstract byte[] getBytecode();

    public abstract ClassCopySource cached();

    public static ClassCopySource create(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Copying classes from the bootstrap classloader is not supported!");
        }
        String classFileName = className.replace('.', '/') + ".class";
        return new Lazy(classLoader, classFileName);
    }

    public static ClassCopySource create(Class<?> loadedClass) {
        return ClassCopySource.create(loadedClass.getName(), loadedClass.getClassLoader());
    }

    private static class Lazy
    extends ClassCopySource {
        private final ClassLoader classLoader;
        private final String resourceName;

        private Lazy(ClassLoader classLoader, String resourceName) {
            this.classLoader = classLoader;
            this.resourceName = resourceName;
        }

        @Override
        public URL getUrl() {
            URL url = this.classLoader.getResource(this.resourceName);
            if (url == null) {
                throw new IllegalStateException("Classfile " + this.resourceName + " does not exist in the provided classloader!");
            }
            return url;
        }

        @Override
        public byte[] getBytecode() {
            byte[] byArray;
            block8: {
                InputStream bytecodeStream = this.getUrl().openStream();
                try {
                    byArray = StreamDrainer.DEFAULT.drain(bytecodeStream);
                    if (bytecodeStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (bytecodeStream != null) {
                            try {
                                bytecodeStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to read classfile URL", e);
                    }
                }
                bytecodeStream.close();
            }
            return byArray;
        }

        @Override
        public ClassCopySource cached() {
            return new Cached(this);
        }
    }

    private static class Cached
    extends ClassCopySource {
        private final URL classFileUrl;
        private final byte[] cachedByteCode;

        private Cached(Lazy from) {
            this.classFileUrl = from.getUrl();
            this.cachedByteCode = from.getBytecode();
        }

        @Override
        public URL getUrl() {
            return this.classFileUrl;
        }

        @Override
        public byte[] getBytecode() {
            return this.cachedByteCode;
        }

        @Override
        public ClassCopySource cached() {
            return this;
        }
    }
}

