/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.config;

import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;

public final class AgentConfig {
    public static boolean isInstrumentationEnabled(ConfigProperties config, Iterable<String> instrumentationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : instrumentationNames) {
            String propertyName = "otel.instrumentation." + name + ".enabled";
            boolean enabled = config.getBoolean(propertyName, defaultEnabled);
            if (defaultEnabled) {
                anyEnabled &= enabled;
                continue;
            }
            anyEnabled |= enabled;
        }
        return anyEnabled;
    }

    public static boolean isDebugModeEnabled(ConfigProperties config) {
        return config.getBoolean("otel.javaagent.debug", false);
    }

    private AgentConfig() {
    }
}

