/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.ignore;

import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesBuilder;
import io.opentelemetry.javaagent.tooling.ignore.IgnoreAllow;
import io.opentelemetry.javaagent.tooling.ignore.trie.Trie;

public class IgnoredTypesBuilderImpl
implements IgnoredTypesBuilder {
    private final Trie.Builder<IgnoreAllow> ignoredTypesTrie = Trie.newBuilder();
    private final Trie.Builder<IgnoreAllow> ignoredClassLoadersTrie = Trie.newBuilder();

    public IgnoredTypesBuilder ignoreClass(String classNameOrPrefix) {
        this.ignoredTypesTrie.put(classNameOrPrefix, IgnoreAllow.IGNORE);
        return this;
    }

    public IgnoredTypesBuilder allowClass(String classNameOrPrefix) {
        this.ignoredTypesTrie.put(classNameOrPrefix, IgnoreAllow.ALLOW);
        return this;
    }

    public IgnoredTypesBuilder ignoreClassLoader(String classNameOrPrefix) {
        this.ignoredClassLoadersTrie.put(classNameOrPrefix, IgnoreAllow.IGNORE);
        return this;
    }

    public IgnoredTypesBuilder allowClassLoader(String classNameOrPrefix) {
        this.ignoredClassLoadersTrie.put(classNameOrPrefix, IgnoreAllow.ALLOW);
        return this;
    }

    public IgnoredTypesBuilder ignoreTaskClass(String className) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public IgnoredTypesBuilder allowTaskClass(String className) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Trie<IgnoreAllow> buildIgnoredTypesTrie() {
        return this.ignoredTypesTrie.build();
    }

    public Trie<IgnoreAllow> buildIgnoredClassLoadersTrie() {
        return this.ignoredClassLoadersTrie.build();
    }
}

