/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.config;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.spi.config.PropertySource;
import io.opentelemetry.javaagent.tooling.SafeServiceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigInitializer {
    private static final Logger log = LoggerFactory.getLogger(ConfigInitializer.class);
    private static final String CONFIGURATION_FILE_PROPERTY = "otel.javaagent.configuration-file";
    private static final String CONFIGURATION_FILE_ENV_VAR = "OTEL_JAVAAGENT_CONFIGURATION_FILE";

    public static void initialize() {
        Config.internalInitializeConfig((Config)ConfigInitializer.create(ConfigInitializer.loadSpiConfiguration(), ConfigInitializer.loadConfigurationFile()));
    }

    static Config create(Properties spiConfiguration, Properties configurationFile) {
        return Config.newBuilder().readProperties(spiConfiguration).readProperties(configurationFile).readEnvironmentVariables().readSystemProperties().build();
    }

    private static Properties loadSpiConfiguration() {
        Properties propertiesFromSpi = new Properties();
        for (PropertySource propertySource : SafeServiceLoader.load(PropertySource.class)) {
            propertiesFromSpi.putAll((Map<?, ?>)propertySource.getProperties());
        }
        return propertiesFromSpi;
    }

    private static Properties loadConfigurationFile() {
        Properties properties = new Properties();
        String configurationFilePath = System.getProperty(CONFIGURATION_FILE_PROPERTY);
        if (configurationFilePath == null) {
            configurationFilePath = System.getenv(CONFIGURATION_FILE_ENV_VAR);
        }
        if (configurationFilePath == null) {
            return properties;
        }
        File configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")));
        if (!configurationFile.exists()) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
            return properties;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configurationFile), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        catch (FileNotFoundException fnf) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
        }
        catch (IOException ioe) {
            log.error("Configuration file '{}' cannot be accessed or correctly parsed.", (Object)configurationFilePath);
        }
        return properties;
    }

    private ConfigInitializer() {
    }
}

