/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MethodsConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(MethodsConfigurationParser.class);
    static final String PACKAGE_CLASS_NAME_REGEX = "[\\w.$]+";
    private static final String METHOD_LIST_REGEX = "\\s*(?:\\w+\\s*,)*\\s*(?:\\w+\\s*,?)\\s*";
    private static final String CONFIG_FORMAT = "(?:\\s*[\\w.$]+\\[\\s*(?:\\w+\\s*,)*\\s*(?:\\w+\\s*,?)\\s*]\\s*;)*\\s*[\\w.$]+\\[\\s*(?:\\w+\\s*,)*\\s*(?:\\w+\\s*,?)\\s*]";

    public static Map<String, Set<String>> parse(String configString) {
        String[] classMethods;
        if (configString == null || configString.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        if (!MethodsConfigurationParser.validateConfigString(configString)) {
            log.warn("Invalid trace method config '{}'. Must match 'package.Class$Name[method1,method2];*'.", (Object)configString);
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> toTrace = new HashMap<String, Set<String>>();
        for (String classMethod : classMethods = configString.split(";", -1)) {
            if (classMethod.trim().isEmpty()) continue;
            String[] splitClassMethod = classMethod.split("\\[", -1);
            String className = splitClassMethod[0];
            String method = splitClassMethod[1].trim();
            String methodNames = method.substring(0, method.length() - 1);
            String[] splitMethodNames = methodNames.split(",", -1);
            HashSet<String> trimmedMethodNames = new HashSet<String>(splitMethodNames.length);
            for (String methodName : splitMethodNames) {
                String trimmedMethodName = methodName.trim();
                if (trimmedMethodName.isEmpty()) continue;
                trimmedMethodNames.add(trimmedMethodName);
            }
            if (trimmedMethodNames.isEmpty()) continue;
            toTrace.put(className.trim(), trimmedMethodNames);
        }
        return toTrace;
    }

    private static boolean validateConfigString(String configString) {
        for (String segment : configString.split(";")) {
            if (segment.trim().matches(CONFIG_FORMAT)) continue;
            return false;
        }
        return true;
    }

    private MethodsConfigurationParser() {
    }
}

