/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation;

import io.opentelemetry.javaagent.extension.instrumentation.HelperResourceBuilder;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.bytebuddy.LoggingFailSafeMatcher;
import io.opentelemetry.javaagent.tooling.config.AgentConfig;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementationInstaller;
import io.opentelemetry.javaagent.tooling.field.VirtualFieldImplementationInstallerFactory;
import io.opentelemetry.javaagent.tooling.instrumentation.ConstantAdjuster;
import io.opentelemetry.javaagent.tooling.instrumentation.MuzzleMatcher;
import io.opentelemetry.javaagent.tooling.instrumentation.TypeTransformerImpl;
import io.opentelemetry.javaagent.tooling.muzzle.HelperResourceBuilderImpl;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationModuleMuzzle;
import io.opentelemetry.javaagent.tooling.util.IgnoreFailedTypeMatcher;
import io.opentelemetry.javaagent.tooling.util.NamedMatcher;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.logging.Level;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public final class InstrumentationModuleInstaller {
    static final TransformSafeLogger logger = TransformSafeLogger.getLogger(InstrumentationModule.class);
    public static final ElementMatcher.Junction<AnnotationSource> NOT_DECORATOR_MATCHER = ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.named((String)"javax.decorator.Decorator")));
    private final Instrumentation instrumentation;
    private final VirtualFieldImplementationInstallerFactory virtualFieldInstallerFactory = new VirtualFieldImplementationInstallerFactory();

    public InstrumentationModuleInstaller(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    AgentBuilder install(InstrumentationModule instrumentationModule, AgentBuilder parentAgentBuilder, ConfigProperties config) {
        if (!AgentConfig.isInstrumentationEnabled(config, instrumentationModule.instrumentationNames(), instrumentationModule.defaultEnabled(config))) {
            logger.log(Level.FINE, "Instrumentation {0} is disabled", (Object)instrumentationModule.instrumentationName());
            return parentAgentBuilder;
        }
        List helperClassNames = InstrumentationModuleMuzzle.getHelperClassNames((InstrumentationModule)instrumentationModule);
        HelperResourceBuilderImpl helperResourceBuilder = new HelperResourceBuilderImpl();
        instrumentationModule.registerHelperResources((HelperResourceBuilder)helperResourceBuilder);
        List typeInstrumentations = instrumentationModule.typeInstrumentations();
        if (typeInstrumentations.isEmpty()) {
            if (!helperClassNames.isEmpty() || !helperResourceBuilder.getResources().isEmpty()) {
                logger.log(Level.WARNING, "Helper classes and resources won't be injected if no types are instrumented: {0}", (Object)instrumentationModule.instrumentationName());
            }
            return parentAgentBuilder;
        }
        ElementMatcher.Junction moduleClassLoaderMatcher = instrumentationModule.classLoaderMatcher();
        MuzzleMatcher muzzleMatcher = new MuzzleMatcher(logger, instrumentationModule, config);
        HelperInjector helperInjector = new HelperInjector(instrumentationModule.instrumentationName(), helperClassNames, helperResourceBuilder.getResources(), Utils.getExtensionsClassLoader(), this.instrumentation);
        VirtualFieldImplementationInstaller contextProvider = this.virtualFieldInstallerFactory.create(instrumentationModule);
        AgentBuilder agentBuilder = parentAgentBuilder;
        for (TypeInstrumentation typeInstrumentation : typeInstrumentations) {
            NamedMatcher<TypeDescription> typeMatcher = new NamedMatcher<TypeDescription>(instrumentationModule.getClass().getSimpleName() + "#" + typeInstrumentation.getClass().getSimpleName(), new IgnoreFailedTypeMatcher((ElementMatcher<TypeDescription>)typeInstrumentation.typeMatcher()));
            NamedMatcher classLoaderMatcher = new NamedMatcher(instrumentationModule.getClass().getSimpleName() + "#" + typeInstrumentation.getClass().getSimpleName(), moduleClassLoaderMatcher.and(typeInstrumentation.classLoaderOptimization()));
            AgentBuilder.Identified.Extendable extendableAgentBuilder = ((AgentBuilder.Identified.Narrowable)((AgentBuilder.Identified.Narrowable)agentBuilder.type(new LoggingFailSafeMatcher<TypeDescription>(typeMatcher, "Instrumentation type matcher unexpected exception: " + typeMatcher), new LoggingFailSafeMatcher(classLoaderMatcher, "Instrumentation class loader matcher unexpected exception: " + classLoaderMatcher)).and((typeDescription, classLoader, module, classBeingRedefined, protectionDomain) -> classLoader == null || NOT_DECORATOR_MATCHER.matches((Object)typeDescription))).and((AgentBuilder.RawMatcher)muzzleMatcher)).transform(ConstantAdjuster.instance()).transform((AgentBuilder.Transformer)helperInjector);
            extendableAgentBuilder = contextProvider.rewriteVirtualFieldsCalls(extendableAgentBuilder);
            TypeTransformerImpl typeTransformer = new TypeTransformerImpl(extendableAgentBuilder);
            typeInstrumentation.transform((TypeTransformer)typeTransformer);
            extendableAgentBuilder = typeTransformer.getAgentBuilder();
            extendableAgentBuilder = contextProvider.injectFields(extendableAgentBuilder);
            agentBuilder = extendableAgentBuilder;
        }
        return agentBuilder;
    }
}

