/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.matcher;

import io.opentelemetry.instrumentation.api.caching.Cache;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.spi.IgnoreMatcherProvider;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalClassloaderIgnoresMatcher
extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
    private static final Logger log = LoggerFactory.getLogger(GlobalClassloaderIgnoresMatcher.class);
    private static final String AGENT_CLASSLOADER_NAME = "io.opentelemetry.javaagent.bootstrap.AgentClassLoader";
    private static final String EXPORTER_CLASSLOADER_NAME = "io.opentelemetry.javaagent.tooling.ExporterClassLoader";
    private static final Cache<ClassLoader, Boolean> skipCache = Cache.newBuilder().setWeakKeys().build();
    private final IgnoreMatcherProvider ignoreMatcherProviders;

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> skipClassLoader(IgnoreMatcherProvider ignoreMatcherProvider) {
        return new GlobalClassloaderIgnoresMatcher(ignoreMatcherProvider);
    }

    private GlobalClassloaderIgnoresMatcher(IgnoreMatcherProvider ignoreMatcherProviders) {
        this.ignoreMatcherProviders = ignoreMatcherProviders;
    }

    public boolean matches(ClassLoader cl) {
        IgnoreMatcherProvider.Result ignoreResult = this.ignoreMatcherProviders.classloader(cl);
        switch (ignoreResult) {
            case IGNORE: {
                return true;
            }
            case ALLOW: {
                return false;
            }
        }
        if (cl == ClassLoadingStrategy.BOOTSTRAP_LOADER) {
            return false;
        }
        if (GlobalClassloaderIgnoresMatcher.canSkipClassLoaderByName(cl)) {
            return true;
        }
        return (Boolean)skipCache.computeIfAbsent((Object)cl, c -> !GlobalClassloaderIgnoresMatcher.delegatesToBootstrap(cl));
    }

    private static boolean canSkipClassLoaderByName(ClassLoader loader) {
        String name;
        switch (name = loader.getClass().getName()) {
            case "org.codehaus.groovy.runtime.callsite.CallSiteClassLoader": 
            case "sun.reflect.DelegatingClassLoader": 
            case "jdk.internal.reflect.DelegatingClassLoader": 
            case "clojure.lang.DynamicClassLoader": 
            case "org.apache.cxf.common.util.ASMHelper$TypeHelperClassLoader": 
            case "sun.misc.Launcher$ExtClassLoader": 
            case "io.opentelemetry.javaagent.bootstrap.AgentClassLoader": 
            case "io.opentelemetry.javaagent.tooling.ExporterClassLoader": {
                return true;
            }
        }
        return name.startsWith("datadog.") || name.startsWith("com.dynatrace.") || name.startsWith("com.appdynamics.") || name.startsWith("com.newrelic.agent.") || name.startsWith("com.newrelic.api.agent.") || name.startsWith("com.nr.agent.");
    }

    private static boolean delegatesToBootstrap(ClassLoader loader) {
        boolean delegates = true;
        if (!GlobalClassloaderIgnoresMatcher.loadsExpectedClass(loader, PatchLogger.class)) {
            log.debug("loader {} failed to delegate bootstrap agent class", (Object)loader);
            delegates = false;
        }
        return delegates;
    }

    private static boolean loadsExpectedClass(ClassLoader loader, Class<?> expectedClass) {
        try {
            return loader.loadClass(expectedClass.getName()) == expectedClass;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

