/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.spi.AgentExtension;
import io.opentelemetry.javaagent.instrumentation.api.SafeServiceLoader;
import io.opentelemetry.javaagent.tooling.instrumentation.InstrumentationModuleInstaller;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.bytebuddy.agent.builder.AgentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={AgentExtension.class})
public class InstrumentationLoader
implements AgentExtension {
    private static final Logger log = LoggerFactory.getLogger(InstrumentationLoader.class);
    private final InstrumentationModuleInstaller instrumentationModuleInstaller = new InstrumentationModuleInstaller();

    public AgentBuilder extend(AgentBuilder agentBuilder) {
        List instrumentationModules = SafeServiceLoader.load(InstrumentationModule.class, (ClassLoader)InstrumentationLoader.class.getClassLoader()).stream().sorted(Comparator.comparingInt(InstrumentationModule::order)).collect(Collectors.toList());
        int numberOfLoadedModules = 0;
        for (InstrumentationModule instrumentationModule : instrumentationModules) {
            log.debug("Loading instrumentation {} [class {}]", (Object)instrumentationModule.instrumentationName(), (Object)instrumentationModule.getClass().getName());
            try {
                agentBuilder = this.instrumentationModuleInstaller.install(instrumentationModule, agentBuilder);
                ++numberOfLoadedModules;
            }
            catch (Exception | LinkageError e) {
                log.error("Unable to load instrumentation {} [class {}]", new Object[]{instrumentationModule.instrumentationName(), instrumentationModule.getClass().getName(), e});
            }
        }
        log.debug("Installed {} instrumenter(s)", (Object)numberOfLoadedModules);
        return agentBuilder;
    }

    public String extensionName() {
        return "instrumentation-loader";
    }
}

