/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.bootstrap.AgentStarter;
import io.opentelemetry.javaagent.tooling.AgentInstaller;
import io.opentelemetry.javaagent.tooling.DefaultLoggingCustomizer;
import io.opentelemetry.javaagent.tooling.ExtensionClassLoader;
import io.opentelemetry.javaagent.tooling.LoggingCustomizer;
import io.opentelemetry.javaagent.tooling.config.ConfigInitializer;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AgentStarterImpl
implements AgentStarter {
    private final Instrumentation instrumentation;
    private final File javaagentFile;
    private ClassLoader extensionClassLoader;

    public AgentStarterImpl(Instrumentation instrumentation, File javaagentFile) {
        this.instrumentation = instrumentation;
        this.javaagentFile = javaagentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delayStart() {
        LaunchHelperClassFileTransformer transformer = new LaunchHelperClassFileTransformer();
        this.instrumentation.addTransformer(transformer, true);
        try {
            Class<?> clazz = Class.forName("sun.launcher.LauncherHelper", false, null);
            if (transformer.transformed) {
                boolean bl = transformer.hookInserted;
                return bl;
            }
            this.instrumentation.retransformClasses(clazz);
            boolean bl = transformer.hookInserted;
            return bl;
        }
        catch (ClassNotFoundException | UnmodifiableClassException exception) {
        }
        finally {
            this.instrumentation.removeTransformer(transformer);
        }
        return false;
    }

    public void start() {
        this.extensionClassLoader = AgentStarterImpl.createExtensionClassLoader(this.getClass().getClassLoader(), this.javaagentFile);
        ClassLoader savedContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.extensionClassLoader);
            this.internalStart();
        }
        finally {
            Thread.currentThread().setContextClassLoader(savedContextClassLoader);
        }
    }

    private void internalStart() {
        Iterator<LoggingCustomizer> loggingCustomizers = ServiceLoader.load(LoggingCustomizer.class).iterator();
        LoggingCustomizer loggingCustomizer = loggingCustomizers.hasNext() ? loggingCustomizers.next() : new DefaultLoggingCustomizer();
        Throwable startupError = null;
        try {
            loggingCustomizer.init();
            ConfigInitializer.initialize();
            AgentInstaller.installBytebuddyAgent(this.instrumentation, Config.get());
        }
        catch (Throwable t) {
            startupError = t;
        }
        if (startupError == null) {
            loggingCustomizer.onStartupSuccess();
        } else {
            loggingCustomizer.onStartupFailure(startupError);
        }
    }

    public ClassLoader getExtensionClassLoader() {
        return this.extensionClassLoader;
    }

    private static ClassLoader createExtensionClassLoader(ClassLoader agentClassLoader, File javaagentFile) {
        return ExtensionClassLoader.getInstance(agentClassLoader, javaagentFile);
    }

    private static class LaunchHelperClassFileTransformer
    implements ClassFileTransformer {
        boolean hookInserted = false;
        boolean transformed = false;

        private LaunchHelperClassFileTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (!"sun/launcher/LauncherHelper".equals(className)) {
                return null;
            }
            this.transformed = true;
            ClassReader cr = new ClassReader(classfileBuffer);
            ClassWriter cw = new ClassWriter(cr, 0);
            ClassVisitor cv = new ClassVisitor(458752, (ClassVisitor)cw){

                public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                    MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                    if ("checkAndLoadMain".equals(name)) {
                        return new MethodVisitor(this.api, mv){

                            public void visitCode() {
                                super.visitCode();
                                hookInserted = true;
                                this.mv.visitMethodInsn(184, Type.getInternalName(AgentInitializer.class), "delayedStartHook", "()V", false);
                            }
                        };
                    }
                    return mv;
                }
            };
            cr.accept(cv, 0);
            return this.hookInserted ? cw.toByteArray() : null;
        }
    }
}

