/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.TypeInstrumentation;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.bytebuddy.AgentTransformers;
import io.opentelemetry.javaagent.tooling.bytebuddy.ExceptionHandlers;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.tooling.context.FieldBackedProvider;
import io.opentelemetry.javaagent.tooling.context.InstrumentationContextProvider;
import io.opentelemetry.javaagent.tooling.context.NoopContextProvider;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.Mismatch;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.ReferenceMatcher;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstrumentationModule {
    private static final Logger log = LoggerFactory.getLogger(InstrumentationModule.class);
    private static final Logger muzzleLog = LoggerFactory.getLogger((String)"muzzleMatcher");
    private static final String[] EMPTY = new String[0];
    public static final ElementMatcher.Junction<AnnotationSource> NOT_DECORATOR_MATCHER = ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.named((String)"javax.decorator.Decorator")));
    private final Set<String> instrumentationNames;
    protected final boolean enabled;

    public InstrumentationModule(String mainInstrumentationName, String ... additionalInstrumentationNames) {
        this(InstrumentationModule.toList(mainInstrumentationName, additionalInstrumentationNames));
    }

    public InstrumentationModule(List<String> instrumentationNames) {
        if (instrumentationNames.isEmpty()) {
            throw new IllegalArgumentException("InstrumentationModules must be named");
        }
        this.instrumentationNames = new LinkedHashSet<String>(instrumentationNames);
        this.enabled = Config.get().isInstrumentationEnabled(this.instrumentationNames, this.defaultEnabled());
    }

    private static List<String> toList(String first, String[] rest) {
        ArrayList<String> instrumentationNames = new ArrayList<String>(rest.length + 1);
        instrumentationNames.add(first);
        instrumentationNames.addAll(Arrays.asList(rest));
        return instrumentationNames;
    }

    public final AgentBuilder instrument(AgentBuilder parentAgentBuilder) {
        if (!this.enabled) {
            log.debug("Instrumentation {} is disabled", (Object)this.mainInstrumentationName());
            return parentAgentBuilder;
        }
        List<String> helperClassNames = this.getAllHelperClassNames();
        List<String> helperResourceNames = Arrays.asList(this.helperResourceNames());
        List<TypeInstrumentation> typeInstrumentations = this.typeInstrumentations();
        if (typeInstrumentations.isEmpty()) {
            if (!helperClassNames.isEmpty() || !helperResourceNames.isEmpty()) {
                log.warn("Helper classes and resources won't be injected if no types are instrumented: {}", (Object)this.mainInstrumentationName());
            }
            return parentAgentBuilder;
        }
        ElementMatcher.Junction<ClassLoader> moduleClassLoaderMatcher = this.classLoaderMatcher();
        MuzzleMatcher muzzleMatcher = new MuzzleMatcher();
        HelperInjector helperInjector = new HelperInjector(this.mainInstrumentationName(), helperClassNames, helperResourceNames);
        InstrumentationContextProvider contextProvider = this.getContextProvider();
        AgentBuilder agentBuilder = parentAgentBuilder;
        for (TypeInstrumentation typeInstrumentation : typeInstrumentations) {
            AgentBuilder.Identified.Extendable extendableAgentBuilder = ((AgentBuilder.Identified.Narrowable)((AgentBuilder.Identified.Narrowable)agentBuilder.type(AgentElementMatchers.failSafe(typeInstrumentation.typeMatcher(), "Instrumentation type matcher unexpected exception: " + this.getClass().getName()), AgentElementMatchers.failSafe(moduleClassLoaderMatcher.and(typeInstrumentation.classLoaderOptimization()), "Instrumentation class loader matcher unexpected exception: " + this.getClass().getName())).and(NOT_DECORATOR_MATCHER)).and((AgentBuilder.RawMatcher)muzzleMatcher)).transform(AgentTransformers.defaultTransformers()).transform((AgentBuilder.Transformer)helperInjector);
            extendableAgentBuilder = contextProvider.instrumentationTransformer(extendableAgentBuilder);
            extendableAgentBuilder = this.applyInstrumentationTransformers(typeInstrumentation.transformers(), extendableAgentBuilder);
            extendableAgentBuilder = contextProvider.additionalInstrumentation(extendableAgentBuilder);
            agentBuilder = extendableAgentBuilder;
        }
        return agentBuilder;
    }

    public final List<String> getAllHelperClassNames() {
        ArrayList<String> helperClassNames = new ArrayList<String>();
        helperClassNames.addAll(Arrays.asList(this.additionalHelperClassNames()));
        helperClassNames.addAll(Arrays.asList(this.getMuzzleHelperClassNames()));
        return helperClassNames;
    }

    private AgentBuilder.Identified.Extendable applyInstrumentationTransformers(Map<? extends ElementMatcher<? super MethodDescription>, String> transformers, AgentBuilder.Identified.Extendable agentBuilder) {
        for (Map.Entry<? extends ElementMatcher<? super MethodDescription>, String> entry : transformers.entrySet()) {
            agentBuilder = agentBuilder.transform((AgentBuilder.Transformer)new AgentBuilder.Transformer.ForAdvice().include(new ClassLoader[]{Utils.getBootstrapProxy(), Utils.getAgentClassLoader()}).withExceptionHandler(ExceptionHandlers.defaultExceptionHandler()).advice(entry.getKey(), entry.getValue()));
        }
        return agentBuilder;
    }

    private InstrumentationContextProvider getContextProvider() {
        Map<String, String> contextStore = this.contextStore();
        if (!contextStore.isEmpty()) {
            return new FieldBackedProvider(this.getClass(), contextStore);
        }
        return NoopContextProvider.INSTANCE;
    }

    private String mainInstrumentationName() {
        return this.instrumentationNames.iterator().next();
    }

    protected ReferenceMatcher getMuzzleReferenceMatcher() {
        return null;
    }

    protected String[] getMuzzleHelperClassNames() {
        return EMPTY;
    }

    protected String[] additionalHelperClassNames() {
        return EMPTY;
    }

    public int getOrder() {
        return 0;
    }

    public String[] helperResourceNames() {
        return EMPTY;
    }

    public ElementMatcher.Junction<ClassLoader> classLoaderMatcher() {
        return ElementMatchers.any();
    }

    public abstract List<TypeInstrumentation> typeInstrumentations();

    protected Map<String, String> contextStore() {
        return Collections.emptyMap();
    }

    protected boolean defaultEnabled() {
        return Config.get().getBooleanProperty("otel.instrumentation.common.default-enabled", true);
    }

    private class MuzzleMatcher
    implements AgentBuilder.RawMatcher {
        private MuzzleMatcher() {
        }

        public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
            ReferenceMatcher muzzle = InstrumentationModule.this.getMuzzleReferenceMatcher();
            if (muzzle != null) {
                boolean isMatch = muzzle.matches(classLoader);
                if (!isMatch) {
                    if (muzzleLog.isWarnEnabled()) {
                        muzzleLog.warn("Instrumentation skipped, mismatched references were found: {} -- {} on {}", new Object[]{InstrumentationModule.this.mainInstrumentationName(), InstrumentationModule.this.getClass().getName(), classLoader});
                        List<Mismatch> mismatches = muzzle.getMismatchedReferenceSources(classLoader);
                        for (Mismatch mismatch : mismatches) {
                            muzzleLog.warn("-- {}", (Object)mismatch);
                        }
                    }
                } else if (muzzleLog.isDebugEnabled()) {
                    log.debug("Applying instrumentation: {} -- {} on {}", new Object[]{InstrumentationModule.this.mainInstrumentationName(), InstrumentationModule.this.getClass().getName(), classLoader});
                }
                return isMatch;
            }
            return true;
        }
    }
}

