/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.bootstrap.WeakCache;
import io.opentelemetry.javaagent.instrumentation.api.WeakMap;
import io.opentelemetry.javaagent.tooling.AgentInstaller;
import io.opentelemetry.javaagent.tooling.WeakMapSuppliers;
import io.opentelemetry.javaagent.tooling.bytebuddy.AgentCachingPoolStrategy;
import io.opentelemetry.javaagent.tooling.bytebuddy.AgentLocationStrategy;
import java.util.Iterator;
import java.util.ServiceLoader;

public class AgentTooling {
    private static final WeakCache.Provider weakCacheProvider;
    private static final AgentLocationStrategy LOCATION_STRATEGY;
    private static final AgentCachingPoolStrategy POOL_STRATEGY;

    static void registerWeakMapProvider() {
        if (!WeakMap.Provider.isProviderRegistered()) {
            WeakMap.Provider.registerIfAbsent((WeakMap.Implementation)new WeakMapSuppliers.WeakConcurrent());
        }
    }

    private static <K, V> WeakCache.Provider loadWeakCacheProvider() {
        Iterator<WeakCache.Provider> providers = ServiceLoader.load(WeakCache.Provider.class, AgentInstaller.class.getClassLoader()).iterator();
        if (providers.hasNext()) {
            WeakCache.Provider provider = providers.next();
            if (providers.hasNext()) {
                throw new IllegalStateException("Only one implementation of WeakCache.Provider suppose to be in classpath");
            }
            return provider;
        }
        throw new IllegalStateException("Can't load implementation of WeakCache.Provider");
    }

    public static <K, V> WeakCache<K, V> newWeakCache() {
        return weakCacheProvider.newWeakCache();
    }

    public static <K, V> WeakCache<K, V> newWeakCache(long maxSize) {
        return weakCacheProvider.newWeakCache(maxSize);
    }

    public static AgentLocationStrategy locationStrategy() {
        return LOCATION_STRATEGY;
    }

    public static AgentCachingPoolStrategy poolStrategy() {
        return POOL_STRATEGY;
    }

    static {
        AgentTooling.registerWeakMapProvider();
        weakCacheProvider = AgentTooling.loadWeakCacheProvider();
        LOCATION_STRATEGY = new AgentLocationStrategy();
        POOL_STRATEGY = new AgentCachingPoolStrategy();
    }
}

