/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.tooling.AgentInstaller;
import java.lang.reflect.Method;
import java.net.URL;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Utils {
    private static Method findLoadedClassMethod = null;
    private static final AgentClassLoader.BootstrapClassLoaderProxy unitTestBootstrapProxy = new AgentClassLoader.BootstrapClassLoaderProxy(new URL[0]);

    public static ClassLoader getAgentClassLoader() {
        return AgentInstaller.class.getClassLoader();
    }

    public static AgentClassLoader.BootstrapClassLoaderProxy getBootstrapProxy() {
        if (Utils.getAgentClassLoader() instanceof AgentClassLoader) {
            return ((AgentClassLoader)Utils.getAgentClassLoader()).getBootstrapProxy();
        }
        return unitTestBootstrapProxy;
    }

    public static String getResourceName(String className) {
        if (!className.endsWith(".class")) {
            return className.replace('.', '/') + ".class";
        }
        return className;
    }

    public static String getClassName(String resourceName) {
        return resourceName.replaceAll("\\.class\\$", "").replace('/', '.');
    }

    public static String getInternalName(String resourceName) {
        return resourceName.replaceAll("\\.class\\$", "").replace('.', '/');
    }

    public static String convertToInnerClassName(String className) {
        return className.replaceAll("\\.", "\\$");
    }

    public static MethodDescription getMethodDefinition(TypeDefinition type, String methodName) {
        return (MethodDescription)((MethodList)type.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)methodName))).getOnly();
    }

    public static String getStackTraceAsString() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringBuilder stringBuilder = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        for (StackTraceElement element : stackTrace) {
            stringBuilder.append(element.toString());
            stringBuilder.append(lineSeparator);
        }
        return stringBuilder.toString();
    }

    private Utils() {
    }

    static {
        try {
            findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
    }
}

