/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.bytebuddy.matcher;

import io.opentelemetry.javaagent.bootstrap.WeakCache;
import io.opentelemetry.javaagent.tooling.AgentTooling;
import net.bytebuddy.matcher.ElementMatcher;

public final class ClassLoaderMatcher {
    public static final ClassLoader BOOTSTRAP_CLASSLOADER = null;

    private ClassLoaderMatcher() {
        throw new UnsupportedOperationException();
    }

    public static ElementMatcher.Junction.AbstractBase<ClassLoader> hasClassesNamed(String ... classNames) {
        return new ClassLoaderHasClassesNamedMatcher(classNames);
    }

    private static class ClassLoaderHasClassesNamedMatcher
    extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
        private final WeakCache<ClassLoader, Boolean> cache = AgentTooling.newWeakCache(25L);
        private final String[] resources;

        private ClassLoaderHasClassesNamedMatcher(String ... classNames) {
            this.resources = classNames;
            for (int i = 0; i < this.resources.length; ++i) {
                this.resources[i] = this.resources[i].replace(".", "/") + ".class";
            }
        }

        private boolean hasResources(ClassLoader cl) {
            for (String resource : this.resources) {
                if (cl.getResource(resource) != null) continue;
                return false;
            }
            return true;
        }

        public boolean matches(ClassLoader cl) {
            if (cl == BOOTSTRAP_CLASSLOADER) {
                return false;
            }
            Boolean cached = (Boolean)this.cache.getIfPresent((Object)cl);
            if (cached != null) {
                return cached;
            }
            boolean value = this.hasResources(cl);
            this.cache.put((Object)cl, (Object)value);
            return value;
        }
    }
}

