/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.bytebuddy.matcher;

import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.SafeHasSuperTypeMatcher;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;

class SafeExtendsClassMatcher<T extends TypeDescription>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super TypeDescription.Generic> matcher;

    public SafeExtendsClassMatcher(ElementMatcher<? super TypeDescription.Generic> matcher) {
        this.matcher = matcher;
    }

    public boolean matches(T target) {
        Object typeDefinition = target;
        while (typeDefinition != null) {
            if (this.matcher.matches((Object)typeDefinition.asGenericType())) {
                return true;
            }
            typeDefinition = SafeHasSuperTypeMatcher.safeGetSuperClass(typeDefinition);
        }
        return false;
    }

    public String toString() {
        return "safeExtendsClass(" + this.matcher + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SafeExtendsClassMatcher)) {
            return false;
        }
        SafeExtendsClassMatcher other = (SafeExtendsClassMatcher)((Object)obj);
        return this.matcher.equals(other.matcher);
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }
}

