/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.matcher;

import io.opentelemetry.javaagent.tooling.muzzle.Reference;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class Mismatch {
    private final Reference.Source[] mismatchSources;

    Mismatch(Reference.Source[] mismatchSources) {
        this.mismatchSources = mismatchSources;
    }

    public String toString() {
        if (this.mismatchSources.length > 0) {
            return this.mismatchSources[0].toString() + " " + this.getMismatchDetails();
        }
        return "<no-source> " + this.getMismatchDetails();
    }

    abstract String getMismatchDetails();

    public static class ReferenceCheckError
    extends Mismatch {
        private final Exception referenceCheckException;
        private final Reference referenceBeingChecked;
        private final ClassLoader classLoaderBeingChecked;

        public ReferenceCheckError(Exception e, Reference referenceBeingChecked, ClassLoader classLoaderBeingChecked) {
            super(new Reference.Source[0]);
            this.referenceCheckException = e;
            this.referenceBeingChecked = referenceBeingChecked;
            this.classLoaderBeingChecked = classLoaderBeingChecked;
        }

        @Override
        String getMismatchDetails() {
            StringWriter sw = new StringWriter();
            sw.write("Failed to generate reference check for: ");
            sw.write(this.referenceBeingChecked.toString());
            sw.write(" on classloader ");
            sw.write(this.classLoaderBeingChecked.toString());
            sw.write("\n");
            PrintWriter pw = new PrintWriter(sw);
            this.referenceCheckException.printStackTrace(pw);
            return sw.toString();
        }
    }

    public static class MissingMethod
    extends Mismatch {
        private final String className;
        private final String methodName;
        private final String methodDescriptor;

        public MissingMethod(Reference.Source[] sources, String className, String methodName, String methodDescriptor) {
            super(sources);
            this.className = className;
            this.methodName = methodName;
            this.methodDescriptor = methodDescriptor;
        }

        @Override
        String getMismatchDetails() {
            return "Missing method " + this.className + "#" + this.methodName + this.methodDescriptor;
        }
    }

    public static class MissingField
    extends Mismatch {
        private final String className;
        private final String fieldName;
        private final String fieldDesc;

        public MissingField(Reference.Source[] sources, String className, String fieldName, String fieldDesc) {
            super(sources);
            this.className = className;
            this.fieldName = fieldName;
            this.fieldDesc = fieldDesc;
        }

        @Override
        String getMismatchDetails() {
            return "Missing field " + this.className + "#" + this.fieldName + this.fieldDesc;
        }
    }

    public static class MissingFlag
    extends Mismatch {
        private final Reference.Flag expectedFlag;
        private final String classMethodOrFieldDesc;
        private final int foundAccess;

        public MissingFlag(Reference.Source[] sources, String classMethodOrFieldDesc, Reference.Flag expectedFlag, int foundAccess) {
            super(sources);
            this.classMethodOrFieldDesc = classMethodOrFieldDesc;
            this.expectedFlag = expectedFlag;
            this.foundAccess = foundAccess;
        }

        @Override
        String getMismatchDetails() {
            return this.classMethodOrFieldDesc + " requires flag " + this.expectedFlag + " found " + this.foundAccess;
        }
    }

    public static class MissingClass
    extends Mismatch {
        private final String className;

        public MissingClass(Reference.Source[] sources, String className) {
            super(sources);
            this.className = className;
        }

        @Override
        String getMismatchDetails() {
            return "Missing class " + this.className;
        }
    }
}

