/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.opentelemetry.javaagent.bootstrap.WeakCache;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuavaWeakCache<K, V>
implements WeakCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(GuavaWeakCache.class);
    private final Cache<K, V> cache;

    private GuavaWeakCache(Cache<K, V> cache) {
        this.cache = cache;
    }

    public V getIfPresent(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    public V getIfPresentOrCompute(K key, Callable<? extends V> loader) {
        Object v = this.cache.getIfPresent(key);
        if (v != null) {
            return (V)v;
        }
        try {
            return (V)this.cache.get(key, loader);
        }
        catch (ExecutionException e) {
            log.error("Can't get value from cache", (Throwable)e);
            return null;
        }
    }

    public V get(K key, Callable<? extends V> loader) {
        try {
            return (V)this.cache.get(key, loader);
        }
        catch (ExecutionException e) {
            log.error("Can't get value from cache", (Throwable)e);
            return null;
        }
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public static final class Provider<K, V>
    implements WeakCache.Provider<K, V> {
        private static final int CACHE_CONCURRENCY = Math.max(8, Runtime.getRuntime().availableProcessors());

        public GuavaWeakCache<K, V> newWeakCache() {
            return new GuavaWeakCache(CacheBuilder.newBuilder().weakKeys().concurrencyLevel(CACHE_CONCURRENCY).expireAfterAccess(10L, TimeUnit.MINUTES).build());
        }

        public GuavaWeakCache<K, V> newWeakCache(long maxSize) {
            return new GuavaWeakCache(CacheBuilder.newBuilder().weakKeys().maximumSize(maxSize).concurrencyLevel(CACHE_CONCURRENCY).expireAfterAccess(10L, TimeUnit.MINUTES).build());
        }
    }
}

