/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.collector;

import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationClassPredicate;
import io.opentelemetry.javaagent.tooling.muzzle.Reference;
import io.opentelemetry.javaagent.tooling.muzzle.collector.ReferenceCollectingClassVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;

public class ReferenceCollector {
    private final Map<String, Reference> references = new LinkedHashMap<String, Reference>();
    private final MutableGraph<String> helperSuperClassGraph = GraphBuilder.directed().build();
    private final Set<String> visitedClasses = new HashSet<String>();

    public void collectReferencesFrom(String adviceClassName) {
        ArrayDeque<String> instrumentationQueue = new ArrayDeque<String>();
        instrumentationQueue.add(adviceClassName);
        boolean isAdviceClass = true;
        while (!instrumentationQueue.isEmpty()) {
            String visitedClassName = (String)instrumentationQueue.remove();
            this.visitedClasses.add(visitedClassName);
            try (InputStream in = ReferenceCollector.getClassFileStream(visitedClassName);){
                ReferenceCollectingClassVisitor cv = new ReferenceCollectingClassVisitor(isAdviceClass);
                ClassReader reader = new ClassReader(in);
                reader.accept((ClassVisitor)cv, 4);
                for (Map.Entry<String, Reference> entry : cv.getReferences().entrySet()) {
                    String refClassName = entry.getKey();
                    Reference reference = entry.getValue();
                    if (!this.visitedClasses.contains(refClassName) && InstrumentationClassPredicate.isInstrumentationClass(refClassName)) {
                        instrumentationQueue.add(refClassName);
                    }
                    this.addReference(refClassName, reference);
                }
                this.collectHelperClasses(isAdviceClass, visitedClassName, cv.getHelperClasses(), cv.getHelperSuperClasses());
            }
            catch (IOException e) {
                throw new IllegalStateException("Error reading class " + visitedClassName, e);
            }
            if (!isAdviceClass) continue;
            isAdviceClass = false;
        }
    }

    private static InputStream getClassFileStream(String className) throws IOException {
        URLConnection connection = ((URL)Preconditions.checkNotNull((Object)ReferenceCollector.class.getClassLoader().getResource(Utils.getResourceName(className)), (String)"Couldn't find class file %s", (Object)className)).openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    private void addReference(String refClassName, Reference reference) {
        if (this.references.containsKey(refClassName)) {
            this.references.put(refClassName, this.references.get(refClassName).merge(reference));
        } else {
            this.references.put(refClassName, reference);
        }
    }

    private void collectHelperClasses(boolean isAdviceClass, String className, Set<String> helperClasses, Set<String> helperSuperClasses) {
        for (String helperClass : helperClasses) {
            this.helperSuperClassGraph.addNode((Object)helperClass);
        }
        if (!isAdviceClass) {
            for (String helperSuperClass : helperSuperClasses) {
                this.helperSuperClassGraph.putEdge((Object)className, (Object)helperSuperClass);
            }
        }
    }

    public Map<String, Reference> getReferences() {
        return this.references;
    }

    public List<String> getSortedHelperClasses() {
        MutableGraph dependencyGraph = Graphs.copyOf((Graph)Graphs.transpose(this.helperSuperClassGraph));
        ArrayList<String> helperClasses = new ArrayList<String>(dependencyGraph.nodes().size());
        Queue<String> helpersWithNoDeps = ReferenceCollector.findAllHelperClassesWithoutDependencies((Graph<String>)dependencyGraph);
        while (!helpersWithNoDeps.isEmpty()) {
            String helperClass = helpersWithNoDeps.remove();
            helperClasses.add(helperClass);
            HashSet dependencies = new HashSet(dependencyGraph.successors((Object)helperClass));
            for (String dependency : dependencies) {
                dependencyGraph.removeEdge((Object)helperClass, (Object)dependency);
                if (!dependencyGraph.predecessors((Object)dependency).isEmpty()) continue;
                helpersWithNoDeps.add(dependency);
            }
        }
        return helperClasses;
    }

    private static Queue<String> findAllHelperClassesWithoutDependencies(Graph<String> dependencyGraph) {
        LinkedList<String> helpersWithNoDeps = new LinkedList<String>();
        for (String helperClass : dependencyGraph.nodes()) {
            if (!dependencyGraph.predecessors((Object)helperClass).isEmpty()) continue;
            helpersWithNoDeps.add(helperClass);
        }
        return helpersWithNoDeps;
    }
}

