/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class AgentInitializer {
    private static @Nullable ClassLoader agentClassLoader = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Instrumentation inst, File javaagentFile) throws Exception {
        if (agentClassLoader == null) {
            agentClassLoader = AgentInitializer.createAgentClassLoader("inst", javaagentFile);
            Class<?> agentInstallerClass = agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.AgentInstaller");
            Method agentInstallerMethod = agentInstallerClass.getMethod("installBytebuddyAgent", Instrumentation.class);
            ClassLoader savedContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(agentClassLoader);
                agentInstallerMethod.invoke(null, inst);
            }
            finally {
                Thread.currentThread().setContextClassLoader(savedContextClassLoader);
            }
        }
    }

    public static synchronized ClassLoader getAgentClassLoader() {
        return agentClassLoader;
    }

    private static ClassLoader createAgentClassLoader(String innerJarFilename, File javaagentFile) throws Exception {
        ClassLoader agentParent = AgentInitializer.isJavaBefore9() ? null : AgentInitializer.getPlatformClassLoader();
        AgentClassLoader agentClassLoader = new AgentClassLoader(javaagentFile, innerJarFilename, agentParent);
        Class<?> extensionClassLoaderClass = agentClassLoader.loadClass("io.opentelemetry.javaagent.tooling.ExtensionClassLoader");
        return (ClassLoader)extensionClassLoaderClass.getDeclaredMethod("getInstance", ClassLoader.class, File.class).invoke(null, agentClassLoader, javaagentFile);
    }

    private static ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
        return (ClassLoader)method.invoke(null, new Object[0]);
    }

    public static boolean isJavaBefore9() {
        return System.getProperty("java.version").startsWith("1.");
    }

    private AgentInitializer() {
    }
}

