/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;

public class AgentClassLoader
extends URLClassLoader {
    private static final String AGENT_INITIALIZER_JAR;
    private static final String META_INF = "META-INF/";
    private static final String META_INF_VERSIONS = "META-INF/versions/";
    private static final int MIN_MULTI_RELEASE_JAR_JAVA_VERSION = 9;
    private static final int JAVA_VERSION;
    private static final boolean MULTI_RELEASE_JAR_ENABLE;
    private final BootstrapClassLoaderProxy bootstrapProxy;
    private final JarFile jarFile;
    private final URL jarBase;
    private final String jarEntryPrefix;
    private final CodeSource codeSource;
    private final Manifest manifest;

    public AgentClassLoader(File javaagentFile, String internalJarFileName) {
        super(new URL[0], (ClassLoader)null);
        if (javaagentFile == null) {
            throw new IllegalArgumentException("Agent jar location should be set");
        }
        if (internalJarFileName == null) {
            throw new IllegalArgumentException("Internal jar file name should be set");
        }
        this.bootstrapProxy = new BootstrapClassLoaderProxy(this);
        this.jarEntryPrefix = internalJarFileName + (internalJarFileName.isEmpty() || internalJarFileName.endsWith("/") ? "" : "/");
        try {
            this.jarFile = new JarFile(javaagentFile, false);
            this.jarBase = new URL("x-internal-jar", null, 0, "/", new AgentClassLoaderUrlStreamHandler(this.jarFile));
            this.codeSource = new CodeSource(javaagentFile.toURI().toURL(), (Certificate[])null);
            this.manifest = this.jarFile.getManifest();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open agent jar", e);
        }
        if (!AGENT_INITIALIZER_JAR.isEmpty()) {
            URL url;
            try {
                url = new File(AGENT_INITIALIZER_JAR).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Filename could not be parsed: " + AGENT_INITIALIZER_JAR + ". Initializer is not installed", e);
            }
            this.addURL(url);
        }
    }

    private static int getJavaVersion() {
        String javaSpecVersion = System.getProperty("java.specification.version");
        if ("1.8".equals(javaSpecVersion)) {
            return 8;
        }
        return Integer.parseInt(javaSpecVersion);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if ("io.grpc.override.ContextStorageOverride".equals(name)) {
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        JarEntry jarEntry = this.findJarEntry(name.replace('.', '/') + ".class");
        if (jarEntry != null) {
            byte[] bytes;
            try {
                bytes = this.getJarEntryBytes(jarEntry);
            }
            catch (IOException exception) {
                throw new ClassNotFoundException(name, exception);
            }
            this.definePackageIfNeeded(name);
            return this.defineClass(name, bytes);
        }
        return super.findClass(name);
    }

    public Class<?> defineClass(String name, byte[] bytes) {
        return this.defineClass(name, bytes, 0, bytes.length, this.codeSource);
    }

    private byte[] getJarEntryBytes(JarEntry jarEntry) throws IOException {
        int size = (int)jarEntry.getSize();
        byte[] buffer = new byte[size];
        try (InputStream is = this.jarFile.getInputStream(jarEntry);){
            int read;
            for (int offset = 0; offset < size && (read = is.read(buffer, offset, size - offset)) != -1; offset += read) {
            }
        }
        return buffer;
    }

    private void definePackageIfNeeded(String className) {
        block4: {
            String packageName = AgentClassLoader.getPackageName(className);
            if (packageName == null) {
                return;
            }
            if (this.getPackage(packageName) == null) {
                try {
                    this.definePackage(packageName, this.manifest, this.codeSource.getLocation());
                }
                catch (IllegalArgumentException exception) {
                    if (this.getPackage(packageName) != null) break block4;
                    throw new IllegalStateException("Failed to define package", exception);
                }
            }
        }
    }

    private static String getPackageName(String className) {
        int index = className.lastIndexOf(46);
        return index == -1 ? null : className.substring(0, index);
    }

    private JarEntry findJarEntry(String name) {
        boolean isClass = name.endsWith(".class");
        if (isClass) {
            name = name + this.getClassSuffix();
        }
        JarEntry jarEntry = this.jarFile.getJarEntry(this.jarEntryPrefix + name);
        if (MULTI_RELEASE_JAR_ENABLE) {
            jarEntry = this.findVersionedJarEntry(jarEntry, name);
        }
        return jarEntry;
    }

    protected String getClassSuffix() {
        return "data";
    }

    private JarEntry findVersionedJarEntry(JarEntry jarEntry, String name) {
        if (!name.startsWith(META_INF)) {
            for (int version = JAVA_VERSION; version >= 9; --version) {
                JarEntry versionedJarEntry = this.jarFile.getJarEntry(this.jarEntryPrefix + META_INF_VERSIONS + version + "/" + name);
                if (versionedJarEntry == null) continue;
                return versionedJarEntry;
            }
        }
        return jarEntry;
    }

    @Override
    public URL getResource(String resourceName) {
        URL bootstrapResource = this.bootstrapProxy.getResource(resourceName);
        if (null == bootstrapResource) {
            return super.getResource(resourceName);
        }
        return bootstrapResource;
    }

    @Override
    public URL findResource(String name) {
        URL url = this.findJarResource(name);
        if (url != null) {
            return url;
        }
        return super.findResource(name);
    }

    private URL findJarResource(String name) {
        JarEntry jarEntry = this.findJarEntry(name);
        return this.getJarEntryUrl(jarEntry);
    }

    private URL getJarEntryUrl(JarEntry jarEntry) {
        if (jarEntry != null) {
            try {
                return new URL(this.jarBase, jarEntry.getName());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to construct url for jar entry " + jarEntry.getName(), e);
            }
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        final Enumeration<URL> delegate = super.findResources(name);
        final URL url = this.findJarResource(name);
        if (url != null) {
            return new Enumeration<URL>(){
                boolean first = true;

                @Override
                public boolean hasMoreElements() {
                    return this.first || delegate.hasMoreElements();
                }

                @Override
                public URL nextElement() {
                    if (this.first) {
                        this.first = false;
                        return url;
                    }
                    return (URL)delegate.nextElement();
                }
            };
        }
        return delegate;
    }

    public BootstrapClassLoaderProxy getBootstrapProxy() {
        return this.bootstrapProxy;
    }

    static {
        ClassLoader.registerAsParallelCapable();
        AGENT_INITIALIZER_JAR = System.getProperty("otel.javaagent.experimental.initializer.jar", "");
        JAVA_VERSION = AgentClassLoader.getJavaVersion();
        MULTI_RELEASE_JAR_ENABLE = JAVA_VERSION >= 9;
    }

    private static class AgentClassLoaderUrlConnection
    extends URLConnection {
        private final JarFile jarFile;
        @Nullable
        private final String entryName;
        @Nullable
        private JarEntry jarEntry;

        AgentClassLoaderUrlConnection(URL url, JarFile jarFile) {
            super(url);
            this.jarFile = jarFile;
            String path = url.getFile();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.isEmpty()) {
                path = null;
            }
            this.entryName = path;
        }

        @Override
        public void connect() throws IOException {
            if (!this.connected) {
                if (this.entryName != null) {
                    this.jarEntry = this.jarFile.getJarEntry(this.entryName);
                    if (this.jarEntry == null) {
                        throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
                    }
                }
                this.connected = true;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            if (this.entryName == null) {
                throw new IOException("no entry name specified");
            }
            if (this.jarEntry == null) {
                throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
            }
            return this.jarFile.getInputStream(this.jarEntry);
        }

        @Override
        public Permission getPermission() {
            return null;
        }

        @Override
        public long getContentLengthLong() {
            try {
                this.connect();
                if (this.jarEntry != null) {
                    return this.jarEntry.getSize();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return -1L;
        }
    }

    private static class AgentClassLoaderUrlStreamHandler
    extends URLStreamHandler {
        private final JarFile jarFile;

        AgentClassLoaderUrlStreamHandler(JarFile jarFile) {
            this.jarFile = jarFile;
        }

        @Override
        protected URLConnection openConnection(URL url) {
            return new AgentClassLoaderUrlConnection(url, this.jarFile);
        }
    }

    public static final class BootstrapClassLoaderProxy
    extends ClassLoader {
        private final AgentClassLoader agentClassLoader;

        public BootstrapClassLoaderProxy(AgentClassLoader agentClassLoader) {
            super(null);
            this.agentClassLoader = agentClassLoader;
        }

        @Override
        public URL getResource(String resourceName) {
            URL url = super.getResource(resourceName);
            if (url != null) {
                return url;
            }
            if (this.agentClassLoader != null) {
                JarEntry jarEntry = this.agentClassLoader.jarFile.getJarEntry(resourceName);
                return this.agentClassLoader.getJarEntryUrl(jarEntry);
            }
            return null;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

