/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent;

import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.bootstrap.InstrumentationHolder;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class OpenTelemetryAgent {
    public static void premain(String agentArgs, Instrumentation inst) {
        OpenTelemetryAgent.startAgent(inst, true);
    }

    public static void agentmain(String agentArgs, Instrumentation inst) {
        OpenTelemetryAgent.startAgent(inst, false);
    }

    private static void startAgent(Instrumentation inst, boolean fromPremain) {
        try {
            File javaagentFile = OpenTelemetryAgent.installBootstrapJar(inst);
            InstrumentationHolder.setInstrumentation(inst);
            AgentInitializer.initialize(inst, javaagentFile, fromPremain);
        }
        catch (Throwable ex) {
            System.err.println("ERROR " + OpenTelemetryAgent.class.getName());
            ex.printStackTrace();
        }
    }

    private static synchronized File installBootstrapJar(Instrumentation inst) throws IOException, URISyntaxException {
        CodeSource codeSource = OpenTelemetryAgent.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw new IllegalStateException("could not get agent jar location");
        }
        File javaagentFile = new File(codeSource.getLocation().toURI());
        if (!javaagentFile.isFile()) {
            throw new IllegalStateException("agent jar location doesn't appear to be a file: " + javaagentFile.getAbsolutePath());
        }
        JarFile agentJar = new JarFile(javaagentFile, false);
        OpenTelemetryAgent.verifyJarManifestMainClassIsThis(javaagentFile, agentJar);
        inst.appendToBootstrapClassLoaderSearch(agentJar);
        return javaagentFile;
    }

    private static void verifyJarManifestMainClassIsThis(File jarFile, JarFile agentJar) throws IOException {
        Manifest manifest = agentJar.getManifest();
        if (manifest.getMainAttributes().getValue("Premain-Class") == null) {
            throw new IllegalStateException("The agent was not installed, because the agent was found in '" + jarFile + "', which doesn't contain a Premain-Class manifest attribute. Make sure that you haven't included the agent jar file inside of an application uber jar.");
        }
    }

    public static void main(String ... args) {
        try {
            System.out.println(OpenTelemetryAgent.class.getPackage().getImplementationVersion());
        }
        catch (RuntimeException e) {
            System.out.println("Failed to parse agent version");
            e.printStackTrace();
        }
    }

    private OpenTelemetryAgent() {
    }
}

