/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeServiceLoader {
    private static final Logger log = LoggerFactory.getLogger(SafeServiceLoader.class);

    public static <T> List<T> load(Class<T> serviceClass, ClassLoader classLoader) {
        ArrayList<T> result = new ArrayList<T>();
        ServiceLoader<T> services = ServiceLoader.load(serviceClass, classLoader);
        Iterator<T> iter = services.iterator();
        while (iter.hasNext()) {
            try {
                result.add(iter.next());
            }
            catch (UnsupportedClassVersionError e) {
                log.debug("Unable to load instrumentation class: {}", (Object)e.getMessage());
            }
        }
        return result;
    }
}

