/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.log4j.appender.v2_17;

import io.opentelemetry.instrumentation.api.appender.internal.LogBuilder;
import io.opentelemetry.instrumentation.log4j.appender.v2_17.internal.ContextDataAccessor;
import io.opentelemetry.instrumentation.log4j.appender.v2_17.internal.LogEventMapper;
import io.opentelemetry.javaagent.bootstrap.AgentLogEmitterProvider;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.message.Message;

public final class Log4jHelper {
    private static final LogEventMapper<Map<String, String>> mapper;

    public static void capture(Logger logger, Level level, Message message, Throwable throwable) {
        String instrumentationName = logger.getName();
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            instrumentationName = "ROOT";
        }
        LogBuilder builder = AgentLogEmitterProvider.get().logEmitterBuilder(instrumentationName).build().logBuilder();
        Map contextData = ThreadContext.getImmutableContext();
        mapper.mapLogEvent(builder, message, level, throwable, (Object)contextData);
        builder.emit();
    }

    private Log4jHelper() {
    }

    static {
        InstrumentationConfig config = InstrumentationConfig.get();
        boolean captureExperimentalAttributes = config.getBoolean("otel.instrumentation.log4j-appender.experimental-log-attributes", false);
        boolean captureMapMessageAttributes = config.getBoolean("otel.instrumentation.log4j-appender.experimental.capture-map-message-attributes", false);
        List captureContextDataAttributes = config.getList("otel.instrumentation.log4j-appender.experimental.capture-context-data-attributes", Collections.emptyList());
        mapper = new LogEventMapper((ContextDataAccessor)ContextDataAccessorImpl.INSTANCE, captureExperimentalAttributes, captureMapMessageAttributes, captureContextDataAttributes);
    }

    private static enum ContextDataAccessorImpl implements ContextDataAccessor<Map<String, String>>
    {
        INSTANCE;


        @Nullable
        public Object getValue(Map<String, String> contextData, String key) {
            return contextData.get(key);
        }

        public void forEach(Map<String, String> contextData, BiConsumer<String, Object> action) {
            contextData.forEach(action);
        }
    }
}

